Ext.define('ViewSample.controller.BookController', {
    extend: 'Ext.app.Controller',
    requires: [
        'ViewSample.view.BookDetail',
        'ViewSample.view.BookEdit'
    ],
    config: {
        refs: {
            bookBase: 'bookbase',
            bookDetail: 'bookdetail',
            bookEdit: 'bookedit',
            editButton: '#edit',
            saveButton: '#save'
        },
        control: {
            booklist: {
                itemtap: 'onBookTap'
            },
            bookBase: {
                push: 'onBookPush',
                pop: 'onBookPop'
            },
            editButton: {
                tap: 'onEditTap'
            },
            saveButton: {
                tap: 'onSaveTap'
            }
        }
    },
    
    onBookTap: function(list, idx, node, record){ 
        var detail = Ext.create('ViewSample.view.BookDetail'); 
        detail.setRecord(record); 
        detail.setTitle(record.get('title')); 
        this.getBookBase().push(detail);
    },
    onBookPush: function(view, item){
        var editButton = this.getEditButton();
        var saveButton = this.getSaveButton();
        if(item.xtype == 'bookdetail'){
            editButton.show();
            saveButton.hide();
        }else if(item.xtype == 'bookedit'){
            editButton.hide();
            saveButton.show();
        }
    },
    onBookPop: function(view, item){
        var editButton = this.getEditButton();
        var saveButton = this.getSaveButton();
        if(item.xtype == 'bookdetail'){
            editButton.hide();
            saveButton.hide();
        }else if(item.xtype == 'bookedit'){
            editButton.show();
            saveButton.hide();
        }
    },
    
    onEditTap: function(){
        var edit = Ext.create('ViewSample.view.BookEdit');
        edit.setRecord(this.getBookDetail().getRecord());
        this.getBookBase().push(edit);
    },
    onSaveTap: function(){
        var form = this.getBookEdit();
        var rec = form.getRecord();
        rec.beginEdit();
        form.updateRecord(rec);
        Ext.data.Validations.setPresenceMessage('を入力してください');
        Ext.data.Validations.setLengthMessage('の長さが不正です');
        var errors = rec.validate();
        if(!errors.isValid()){
            var err = errors.getAt(0);
            Ext.Msg.alert('error', err.getField() + ' ' + err.getMessage());
            rec.cancelEdit();
            return;
        }
        rec.endEdit();
        this.getBookDetail().setTitle(rec.get('title'));//変更されない
        this.getBookBase().pop();
    }
});