Ext.define('Hist.controller.History', {
    extend: 'Ext.app.Controller',
    
    config: {
        refs: {
             main: 'main'
        },
        control: {
            main: {
                activeitemchange: 'onActiveItemChange'
            }
        },
        routes: {
            '': 'showTop',
            'top': 'showTop',
            'next': 'showNext',
            'next/:id': 'showNextId'
        }
    },
    onActiveItemChange: function(obj, value, oldValue){
        if(value.config.title == 'First'){
            location.hash = 'top';
            window.title = 'Hist:First';
        }else if(value.config.title == 'Second'){
            location.hash = 'next';
            window.title = 'Hist:Second';
        }
    },
    showTop: function(){
        this.getMain().setActiveItem(0);
    },
    showNext: function(){
        this.getMain().getInnerItems()[1].setHtml('Second page');
        this.getMain().setActiveItem(1);
    },
    showNextId: function(id){
        this.getMain().getInnerItems()[1].setHtml('hello:' + id);
    }
});