Ext.define('FirstApp.view.Native', {
    extend:'Ext.Container',
    xtype: 'native',
    requires: [
        'Ext.device.Notification', 
        'Ext.device.Connection',
        'Ext.device.Camera',
        'Ext.Img'
    ],
    config:{
        title: 'Native',
        iconCls: 'home',
        items:[
            {
                docked: 'top',
                xtype: 'toolbar',
                title: 'Native'
            },
            {
                xtype: 'button',
                text: 'connection',
                handler: function(){
                    Ext.Msg.alert('connection', 
                        Ext.device.Connection.isOnline() ? 
                            'online with ' + Ext.device.Connection.getType() : 
                            'offline');
                }
            },
            {
                xtype: 'button',
                text: 'Notification',
                handler: function(){
                    Ext.device.Notification.show({
                        title: 'Native',
                        message: 'Native Notification Message'
                    });
                }
            },
            {
                xtype: 'button',
                text: 'vibe',
                handler: function(){
                    Ext.device.Notification.vibrate();
                }
            },
            {
                xtype: 'button',
                text: 'camera',
                handler: function(){
                    Ext.device.Camera.capture({
                        source: 'camera',
                        destination: 'file',
                        success: function(url){
                            Ext.Msg.alert('camera', 'captured ' + url, function(){
                                var img = Ext.create('Ext.Img',{
                                    src: url,
                                    fullscreen: true,
                                    listeners:{
                                        tap: function(img){
                                            img.destroy();
                                        }
                                    }
                                });
                                img.show();
                            })
                        }
                    })
                }
            }
        ]
    }
});