Ext.define('FirstApp.view.Main', {
    extend: 'Ext.tab.Panel',
    xtype: 'main',
    requires: [
        'Ext.TitleBar',
        'Ext.Video',
        'Ext.Map',
        'FirstApp.view.Native'
    ],
    config: {
        tabBarPosition: 'bottom',

        items: [
            {xtype: 'native'},
            {
                title: 'Template',
                iconCls: 'info',
                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Template'
                    }
                ],
                data: {
                    foo: 'good',
                    bar: 'day',
                    drinks: [
                        {name: 'beer', price: 400}, 
                        {name: 'wine', price: 350},
                        {name: 'cola', price: 200}],
                    today: new Date(),
                    tagged: '<font size=7>Hello</font>'
                },
                tpl: new Ext.XTemplate(
                    'message:{foo}-{bar}<br/>',
                    '{[ this.hello() ]}<br/>',
                    '{% this.total=0 %}',
                    '<tpl for="drinks">',
                    '{#}-{name} {price}円',
                    '<tpl if="price &gt; 300">☆</tpl>',
                    '<br/>',
                    '{% this.total += values.price %}',
                    '</tpl>',
                    'total:{[this.total]}円<br/>',
                    '{tagged}<br/>',
                    '{tagged:htmlEncode}<br/>',
                    '{today}<br/>',
                    '{today:date("Y/m/d")}<br/>',
                    {
                        hello: function(){ 
                            return 'Hello func'; 
                        } 
                    }) 
            },/*
            {
                title: 'Map',
                iconCls: 'locate',
                layout: 'fit',
                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Map'
                    },
                    {
                        xtype: 'map',
                        mapOptions : {
                            center : new google.maps.LatLng(33.590423,130.402967),
                            zoom : 12,
                            mapTypeId : google.maps.MapTypeId.ROADMAP,
                            mapTypeControl: true,
                            mapTypeControlOptions: {
                                style: google.maps.MapTypeControlStyle.DEFAULT
                            }
                        }
                    }
                ],
                initialize: function(){
                    var map = this.down('map');
                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(33.590423,130.402967),
                        map: map.getMap(),
                        visible: true
                    });
                    var infoWindow = new google.maps.InfoWindow({
                        content: '福岡中央公園'
                    });
                    google.maps.event.addListener(marker, 'click', function(){
                        infoWindow.open(map, marker);
                    });                    
                }                
            },*/
            { 
                title: 'Buttons',
                iconCls: 'info',
                padding: '5px',
                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Button Components'
                    },
                    {
                        xtype: 'button',
                        text: 'hello',
                        /*
                        handler: function(){
                            Ext.Msg.alert("alert", "Hello");
                        }*/
                        /*
                        listeners: {
                            tap: {
                                   buffer: 5000,
                                fn: function(){
                                    Ext.Msg.alert('alert', 'Hello');
                                }
                            }
                        }*/
                        onTap: function(){
                            Ext.Msg.alert('alert', 'Hello');
                        }
                    },
                    {
                        xtype: 'button',
                        text: 'conf',
                        ui: 'round',
                        handler: function(){
                            Ext.Msg.confirm("confirm", "Do you?",
                                function(type){
                                    Ext.Msg.alert("result", type);
                                });
                        }
                    },
                    {
                        xtype: 'button',
                        text: 'prompt',
                        handler: function(){
                            Ext.Msg.prompt("prompt", "input any", 
                                function(btn, text){
                                    if(btn == 'ok'){
                                        Ext.Msg.alert("result", "text:" + text);
                                    }
                                });
                        }
                    },
                    {
                        xtype: 'button',
                        text: 'Pick',
                        handler: function(){
                            var picker = Ext.create('Ext.picker.Picker',{
                                useTitles: true,
                                doneButton: 'Yeah',
                                slots: [
                                    {
                                        name : 'limit',
                                        title: 'Speed',
                                        data: [
                                            {text : '50', value: 50},
                                            {text : '100', value: 100},
                                            {text : '1000', value: 1000}
                                        ]
                                    },
                                    {
                                        name: 'unit',
                                        title: 'Unit',
                                        data: [
                                            {text : 'KB/s', value: 'kb'},
                                            {text : 'MB/s', value: 'mb'}
                                        ]
                                    }
                                ],
                                listeners: {
                                    change: function(picker, value){
                                        Ext.Msg.alert('changed', value.limit + value.unit);
                                    }
                                }
                            });
                            Ext.Viewport.add(picker);
                            picker.show();
                        }
                    },
                    {
                        xtype: 'button',
                        ui: 'cream',
                        text:'クリームボタン'
                    }
                ]
            },            
            {
                title: 'Welcome',
                iconCls: 'home',
                badgeText: '3',

                styleHtmlContent: true,
                scrollable: true,
                layout: 'vbox',

                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Welcome to Sencha Touch 2'
                    },
                    {
                        docked: 'left',
                        xtype: 'panel',
                        width: 100,
                        html: 'left docked panel',
                        style: 'background-color: #ff00ff'
                    },
                    {
                        html: 'first',
                        style: 'background-color: #ffff00',
                        flex: 1
                    },
                    {
                        html: 'second',
                        style: 'color:white; background-color: #0000bb',
                        flex: 2
                    }
                ]
            },
            {
                title: 'Get Started',
                iconCls: 'action',

                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Getting Started'
                    },
                    {
                        xtype: 'video',
                        url: 'http://av.vimeo.com/64284/137/87347327.mp4?token=1330978144_f9b698fea38cd408d52a2393240c896c',
                        posterUrl: 'http://b.vimeocdn.com/ts/261/062/261062119_640.jpg'
                    }
                ]
            }
        ]
    }
});
