Ext.define('Dev.view.Main', {
    extend: 'Ext.tab.Panel',
    xtype: 'main',
    requires: [
        'Ext.TitleBar',
        'Ext.Video'
    ],
    config: {
        tabBarPosition: 'bottom',

        items: [
            {
                title: 'Welcome',
                iconCls: 'home',

                styleHtmlContent: true,
                scrollable: true,

                items: [{
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'Welcome to Sencha Touch 2'
                },
                {
                    xtype: 'button',
                    id: 'hello_button',
                    text: 'Hello'
                }],

                html: [
                    Ext.os.is.Android ? 'Android' : '',
                    Ext.os.is.iOS ? 'iOS' : '',
                    Ext.os.is.Phone ? 'Phone' : '',
                    Ext.os.is.Desktop ? 'Desktop' : '',
                    Ext.os.is.Tablet ? 'Tablet' : '',
                    Ext.browser.is.Chrome ? 'Chrome' : '',
                    Ext.browser.is.Safari ? 'Safari' : '',
                    Ext.feature.has.Canvas ? 'has Canvas' : '',
                    Ext.feature.has.Orientation ? 'has Orientation' : ''
                ].join("<br>")
            },
            {
                title: 'Get Started',
                iconCls: 'action',

                items: [
                    {
                        docked: 'top',
                        xtype: 'titlebar',
                        title: 'Getting Started'
                    },
                    {
                        xtype: 'video',
                        url: 'http://av.vimeo.com/64284/137/87347327.mp4?token=1330978144_f9b698fea38cd408d52a2393240c896c',
                        posterUrl: 'http://b.vimeocdn.com/ts/261/062/261062119_640.jpg'
                    }
                ]
            }
        ]
    }
});
