int r = 10;
float x0 = r, y0 = r;
float x, y; 
float vx = 3, vy = 2;

void setup()
{
  size(300,300);
  colorMode(RGB,255,255,255,100);
  ellipseMode(RADIUS);
  background(0,0,0);
  frameRate(30);

  x = x0;
  y = y0;
}

void draw()
{
 if( isdrag == false )
 {
   noStroke();
   fill( 0, 0, 0, 10 );
   rect( 0, 0, width, height );

   x = x + vx;
   y = y + vy;

   stroke( 0, 0, 100, 100 );
   fill( 0, 200, 255, 100 );
   ellipse( x, y, 10, 10 );

   if( y > height-r ) vy = -vy;
   else if( y < r ) vy = -vy;

   if( x > width-r ) vx = -vx;
   else if( x < r ) vx = -vx;
 }
}

float x1 = 0, y1 = 0;
boolean isdrag = false;
void mousePressed()
{
  isdrag = true;

  x1 = mouseX;     // マウスダウンされたときの座標を保存
  y1 = mouseY;
  
  noStroke();
  fill( 0, 0, 0, 100 );
  rect( 0, 0, width, height );

  stroke( 0, 0, 100, 100 );
  fill( 0, 200, 255, 100 );
  ellipse( x1, y1, 10, 10 );
}

void mouseReleased()
{
  x = x1;
  y = y1;
  vx = (mouseX-x1)/10;
  vy = (mouseY-y1)/10;
  
  stroke( 0, 0, 0, 100 );
  fill( 0, 0, 0, 100 );
  rect( 0, 0, width, height );

  isdrag = false;
}

void mouseDragged()
{
  noStroke();
  fill( 0, 0, 0, 100 );
  rect( 0, 0, width, height );

  stroke( 0, 0, 100, 100 );
  fill( 0, 200, 255, 100 );
  ellipse( x1, y1, 10, 10 );

  stroke( 255, 0, 0, 100 );
  fill( 255, 0, 0 , 100 );
  line( x1, y1, mouseX, mouseY );
}

