import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

int max = 20;
PImage ichigo[] = new PImage[max];
int posx[] = new int[max];
int posy[] = new int[max];
Minim minim;
AudioSnippet song;

void setup()
{
  size( 800, 800 );
  background(255);

  minim = new Minim( this );
  song = minim.loadSnippet("switch1.mp3");
  
  int x = 0, y = 0;  
  for( int i = 0 ; i < max ; i++ )
  {
    ichigo[i] = loadImage( "ichigo.png" );
    posx[i] = x;
    x  += ichigo[0].width;
    if( posx[i]+ichigo[0].width > width )
    {
      x = 0;
      posx[i] = x;
      y += ichigo[0].height;
    }
    posy[i] = y;

  }
}

void stop()
{
  song.close();
  minim.stop();
  super.stop();
}

int rectx[] = {100,450,275};
int recty[] = {150,150,450};
int rectw = 250;
boolean islock = false;
void draw()
{
  noStroke();
  fill(255);
  rect(0,0,width,height);
    
  strokeWeight(3);
  stroke(#0000FF);
  noFill();
  for( int i = 0 ; i < 3 ; i++ )
  {
    rect(rectx[i],recty[i],rectw,rectw);
  }
  
  textSize(60);
  fill(#00C000);
  text( ct[2], rectx[2]+20, recty[2]+60 );
  for( int i = 0 ; i < 2 ; i++ )
  {
    if( islock == false )
    {
      fill(#00C000);
      text( ct[i], rectx[i]+20, recty[i]+60 );
    }
    else
    {
      fill(#FF0000);
      text( lockct[i], rectx[i]+20, recty[i]+60 );
    }
  }

  for( int i = 0 ; i < max ; i++ )
  {
    image( ichigo[i], posx[i], posy[i] );
  }
  
  stroke(#000000);
  if( islock == true )  fill(#FF0000);
                  else  fill(#00C000);
  rect( width-50,height-50,40,40);
}


int isdrag = -1;
int dx,dy;
int lockct[] = new int [2];
void mousePressed()
{
  for( int i = 0 ; i < max ; i++ )
  {
    if( posx[i] < mouseX && posx[i]+ichigo[i].width > mouseX &&
        posy[i] < mouseY && posy[i]+ichigo[i].height > mouseY )
    {
      isdrag = i;
      dx = mouseX - posx[i];
      dy = mouseY - posy[i];
      break;
    }
  }
  
  if( width-50 < mouseX && mouseX < width-10 && 
      height-50 < mouseY && mouseY < height-10 )
  {
    if( islock == true ) islock = false;
    else
    {
      islock = true;
      for( int i = 0 ; i < 2 ; i++ ) lockct[i] = ct[i];
    }
  }
} 
int ct[] = new int[3];
void mouseReleased()
{
  if( isdrag >= 0 )
  {
    song.play();
    song.rewind();
    for( int j = 0 ; j < 3 ; j++ ) ct[j] = 0;    
    for( int i = 0 ; i < max ; i++ )
    {
      for( int j = 0 ; j < 3 ; j++ )
      {
        if( rectx[j] <= posx[i] && 
              posx[i]+ichigo[i].width <= rectx[j]+rectw && 
              recty[j] <= posy[i] && 
              posy[i]+ichigo[i].height <= recty[j]+rectw   ) ct[j]++;
      }
    }
  }
  isdrag = -1;
}
void mouseDragged()
{
  if( isdrag >= 0 )
  {
    posx[isdrag] = mouseX - dx;
    posy[isdrag] = mouseY - dy;
  }
}


