int unit, orgx, orgy;
float[] posx = new float[3];
float[] posy = new float[3];

void setup()
{
  size(600,600);
  background(16,80,3);
  unit = 40;
  orgx = width/2;
  orgy = height/2;
  posx[0] =  0.0; posy[0] =  5.0;
  posx[1] = -4.0; posy[1] = -3.0;
  posx[2] =  4.0; posy[2] = -3.0;
}

int bs = 10;
void draw()
{
  noStroke();
  fill( 16, 80, 3 );
  rect(0,0,width,height);

  drawOrgLine();
  drawTriangle();
  
  int px, py;
  for( int i = 0 ; i <= 2 ; i++ )
  {
    px = GXtoWX(posx[i]);
    py = GYtoWY(posy[i]);
    if (abs(mouseX-px)<bs && abs(mouseY-py)<bs || isdrag == i)
    {
      stroke(#FF0000);
      fill(#FF0000);
      ellipse(px, py, bs*2, bs*2);
    }
  }
}

int isdrag = -1;
void mousePressed() 
{
  int px, py;
  for( int i = 0 ; i <= 2 ; i++ )
  {
    px = GXtoWX(posx[i]);
    py = GYtoWY(posy[i]);
    if (abs(mouseX-px)<bs && abs(mouseY-py)<bs)
    {
      isdrag = i; 
    }
  }
}
void mouseReleased() 
{
  isdrag = -1;
}
void mouseDragged() 
{
  if( isdrag >= 0 ) 
  {
    posx[isdrag] = ceil(WXtoGX(mouseX)-0.5);
    posy[isdrag] = ceil(WYtoGY(mouseY)-0.5);
  }
}

void drawOrgLine()
{
  stroke(127);
  strokeWeight(1);
  for( int x = orgx ; x <= width-1 ; x += unit )
  {
    line( x, 0, x, height-1 );
  }
  for( int x = orgx ; x >= 0 ; x -= unit )
  {
    line( x, 0, x, height-1 );
  }
  for( int y = orgy ; y <= height-1 ; y += unit )
  {
    line( 0, y, width-1, y );
  }
  for( int y = orgy ; y >= 0 ; y -= unit )
  {
    line( 0, y, width-1, y );
  }

  strokeWeight(3);
  line( 0, orgy, width-1, orgy );
  line( orgx, 0, orgx, height-1 );
}

void drawTriangle()
{
  noFill();
  stroke(255);
  strokeWeight(3);

  strokeJoin(MITER);
  beginShape();
    for( int i = 0; i <= 3 ; i++ )
    {
      vertex( GXtoWX( posx[i%3] ), GYtoWY( posy[i%3]) );
    }
  endShape();
}

float WXtoGX( int wx )
{
  float gx = (float)(wx - orgx) / (float)unit;
  return gx;
}
int GXtoWX( float gx )
{
  int wx = orgx + (int)( gx * unit );
  return wx;
}
float WYtoGY( int wy )
{
  float gy = (float)(wy - orgy) / (float)unit;
  return -gy;
}
int GYtoWY( float gy )
{
  int wy = orgy - (int)( gy * unit );
  return wy;
}

