//**********************************************************************************
// Persistence Of Vision Ray tracer version 3.6.1c
// Plane curved line Polar equation Scene File
// By S.Nishimura
//**********************************************************************************

global_settings { assumed_gamma 1.0 max_trace_level 5 }

camera { location -200*z look_at 0 angle 50 }

light_source { 40*y color rgb 1 parallel point_at -z shadowless }

//**********************************************************************************
//create a TrueType text shape parameter Fm:1/2(center)
#macro Tdisp(Txt,Fm,Sc,Tr)
 #local Trns=Tr+<-Fm*strlen(Txt)*Sc/2,-Sc/3,0>;
 object { text { ttf "cyrvetic.ttf", Txt, 1, 0 }
  clipped_by { plane { z,1e-4 } } scale Sc translate Trns no_shadow }
#end
//**********************************************************************************
#macro Edisp(Txt,Vc,Np,Ns,Nt)
#local Ctyp=asc(Txt)-asc("A")+1; #local Ks=Vc.t;
 #switch(Ctyp)
  #case(12)
   #local Symbol=object { Tdisp("5",0,1,0) clipped_by { plane { y,0.18 } } rotate -8*z }
  #break
  #case(13)
   #local Symbol=object { Tdisp(":",0,1,0) rotate 90*z }
  #break
  #case(16)
   #local Symbol=object { Tdisp(":",0,1,0) rotate 90*z }
  #break
 #end
 union {  
  object { Tdisp(Txt,Np,Ns,Nt) }
  object { Symbol translate <Vc.x,Vc.y,0>+Vc.z*Np*x+Nt/(Ks*Ns) scale Ks*Ns }
 }
#end
//**********************************************************************************
//xy-plane curved line parameter Typ:Par=16+1,Fnc=6+14,Equ=5+17,Pol=16+15,Real=18+5
#macro Plane_line(Typ,Lr,V1,V2,Fn)
 #local Ctyp=asc(Typ)+asc(substr(strupr(Typ),2,1))-2*(asc("A")-1);
 #switch(Ctyp)
  #case(17)
   #local P1=Line_function(V1.x,Fn);
   #local Tp=V1.x; #while(Tp<V1.y)
    #local P2=Line_function(Tp+V1.z,Fn);
    cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end #local P1=P2;
   #local Tp=Tp+V1.z; #end
  #break
  #case(20)
   #local P1=< V1.x,Line_function(V1.x,Fn) >;
   #local Tp=V1.x; #while(Tp<V1.y)
    #local P2=< Tp+V1.z, Line_function(Tp+V1.z,Fn)>;
    cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end #local P1=P2;
   #local Tp=Tp+V1.z; #end
  #break
  #case(22)
   #local Fb=0; #local Y=V2.x; #while(Y<V2.y)
    #local Spx=V1.x-V1.z; #local X=Spx; #while(X<V1.y)
     #local F=Line_function(<X,Y>,Fn);
     #if(X!=Spx & F*Fb<0) sphere { <X,Y> Lr } #end #local Fb=F;
    #local X=X+V1.z; #end
   #local Y=Y+V2.z; #end
  #break
  #case(31)
   #local P1=Line_function(V1.x,Fn)*< cos(V1.x), sin(V1.x) >;
   #local Tp=V1.x; #while(Tp<V1.y)
    #local P2=Line_function(Tp+V1.z,Fn)*< cos(Tp+V1.z), sin(Tp+V1.z) >;
    #if(P1.x!=P2.x & P1.y!=P2.y)
     cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end
    #end #local P1=P2;
   #local Tp=Tp+V1.z; #end
  #break
  #else
   #local Tp=V1.x; #while(Tp<V1.y)
    #local P1=Line_function(Tp,Fn);
    #local P2=Line_function(Tp+V1.z,Fn);
    #if(P1.z=0 & P2.z=0) cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end #end
   #local Tp=Tp+V1.z; #end
  #break
 #end
#end // macro end
//**********************************************************************************
#macro Sgn(N) #if(N=0) #local Fg=0; #else #local Fg=N/abs(N); #end Fg #end
//----------------------------------------------------------------------------------
#macro Sgnz(N) #if(N=0) #local Fg=0; #else #local Fg=N/abs(N)-1; #end Fg/2*1e-8 #end
//----------------------------------------------------------------------------------
#macro Epsz(N) #if(N=0) #local N=1e-8; #end N #end
//**********************************************************************************
#macro Line_function(Tp,Fn)
 #switch(Fn)
  //spiral
  #case( 1) #local A=1; #local R=A*Tp; #local F=R; #break //Spiral of Archimedes
  #case( 2) #local A=1; #local R=A*Sgn(Tp)*sqrt(abs(Tp)); #local F=R;#break //Spiral of Fermat
  #case( 3) #local A=5; #local R=A/Epsz(Tp); #local F=R; #break //Hyperbolic spiral 
  #case( 4) #local A=4; #local R=pow(A,2)/Epsz(Tp); #local F=<cos(Tp),Sgn(Tp)*sin(Tp)>*Sgn(R)*sqrt(abs(R)); #break //Lituus
  #case( 5) #local A=1; #local B=1; #local R=A*exp(B*Tp); #local F=R; #break //Logarithmic spiral
  #case( 6) #local A=2/3; #local K=1; #local M=1; #local R=K*pow(A,M*Tp); #local F=R; #break //Spiral of Bernoulli
  #case( 7) #local A=1/2; #local K=2/3; #local M=1; #local R=K*pow(A,M*Tp); #local F=R; #break //Equianguler spiral
  //cissoid
  #case(11) #local R1=1/cos(Tp); #local R2=cos(Tp); #local F=R1-R2; #break //cissoid of Diocles
  #case(12) #local R1=1/cos(Tp); #local R2=tan(Tp); #local F=R1-R2; #break //right strophoid
  #case(13) #local R1=2*sin(3*Tp); #local R2=tan(Tp); #local F=R1-R2; #break
  #case(14) #local R1=pow(sinh(Tp),4); #local R2=exp(Tp); #local F=R1-R2; #break
  #case(15) #local R1=exp(Tp); #local R2=pow(cosh(Tp),1/3); #local F=R1-R2; #break
  //conchoid
  #case(21) #local R1=1/cos(Tp); #local R2=3; #local F=R1-R2; #break //line
  #case(22) #local A=2; #local R1=A*cos(Tp); #local R2=1; #local F=R1-R2; #break //circle(limacon)
  #case(23) #local E=3/4; #local R1=1/(1-E*cos(Tp)); #local R2=3; #local F=R1-R2; #break //ellipse
  #case(24) #local E=5/4; #local R1=1/(1-E*cos(Tp)); #local R2=3; #local F=R1-R2; #break //hyperbola
  #case(25) #local N=7; #local R1=sin(N*Tp); #local R2=2; #local F=R1-R2; #break //rose of n leaves
  #case(26) #local R1=2*sin(Tp/2); #local K=1; #local F=R1-K; #break //Freeth's Nephroid
  //plus
  #case(31) #local A=1; #local R=A/cos(Tp/3); #local F=R; #break //trisectrix of Maclaurin
  #case(32) #local A=1; #local R=A*sin(Tp)/Tp; #local F=R; #break //cochleoid
 #end F
#end
//**********************************************************************************
background { color rgb < 0.25, 0.741, 0.794 > }
//**********************************************************************************
quadric{ <0,1,1>,<0,0,0>,<0,0,0>,-1 scale 1/4 pigment { color rgbt <1,1,0,0.5> } } //x
quadric{ <1,0,1>,<0,0,0>,<0,0,0>,-1 scale 1/4 pigment { color rgbt <1,1,0,0.5> } } //y
//**********************************************************************************
#local Square_seg = object {  plane { z,0 } clipped_by { plane { -y,0 } } hollow }
#local Trns0=<0,55,-1/2>; #local Trns1=<0,-55,-1/2>;
//**********************************************************************************
#local Pc = pigment { color rgb < 0.3, 1.281, 1.388 > }
//----------------------------------------------------------------------------------
#local F1 = finish { ambient 0 diffuse 1 reflection 0.5 specular 0.6 phong 0.2 brilliance 1 }
#local F2 = finish { ambient 0.3 diffuse 1 reflection 1 specular 0.8 phong 0.5 brilliance 1 }
#local F3 = finish { metallic
        ambient 0.2 diffuse 0.35 specular 0.1 roughness 0.01 reflection 0.15 brilliance 0.3 }
//----------------------------------------------------------------------------------
#local Tc = texture { pigment { color rgbt <0.7, 1.0, 0.897, 0.90> } finish { F1 } }
#local Tx = texture { pigment { color rgb <0.25, 0.741, 0.794> } finish { F2 } }
#local Ts = texture { pigment { color rgb <1.017, 1.185, 0> } finish { F3 } }
#local Lc = texture { pigment { color rgb <0.793, 0, 0.106> } finish { F3 } }
//**********************************************************************************
#local Fn=1; //1~4,6
#if(Fn>0)
 object { Square_seg pigment { Pc } translate <0,47,-1/5> }
 object { Tdisp("Spiral",0,7,Trns0-80*x) texture { Tc } }
 object { Square_seg pigment { Pc } translate <0,47,-1/5> rotate 180*z }
#end
#switch(Fn)
 #case( 1)
  object { Tdisp("  Spiral of Archimedes",0,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",1/20,<0,3*pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=A*t , A=1 , ( 0<t<3*pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case( 2)
  object { Tdisp("  Spiral of Fermat",0,8,Trns0) texture { Tx } } #local Sc=12;
  union { Plane_line("Pol",1/(2*Sc),<0,6*pi,1/Sc>,0,Fn) texture { Lc } scale Sc }
  object { Tdisp("r(t)=A*sqrt(t) , A=1 , ( 0<t<6*pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case( 3)
  object { Tdisp("  Hyperbolic spiral",0,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",1/20,<pi/8,5*pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=A/t , A=5 , ( pi/8<t<5*pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case( 4)
  object { Tdisp("  Lituus",0,8,Trns0) texture { Tx } }
  union { Plane_line("Par",1/20,<-4*pi,0-1/10,1/10>,0,Fn) texture { Lc } scale 10 }
  union { Plane_line("Par",1/20,<0,4*pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=A/sqrt(t) , A=-4,A=+4 , ( 0<t<4*pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case( 5)
  object { Tdisp("  Logarithmic spiral",0,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",1/20,<-4*pi,pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=A*exp(B*t) , A=1,B=1 , ( -4*pi<t<pi )",0.425,8,Trns1) texture { Tx } }
 #break
 #case( 6)
  object { Tdisp("  Spiral of Bernoulli",0,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",1/20,<-2*pi,2*pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=K*A^(M*t) , K=1,A=2/3,M=1 , ( -2*pi<t<2*pi )",0.455,7.8,Trns1) texture { Tx } }
 #break
 #case( 7)
  object { Tdisp("  Equianguler spiral",0,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",1/20,<-2*pi,2*pi,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=K*A^(M*t) , K=2/3,A=1/2,M=1 , ( -2*pi<t<2*pi )",0.455,7.6,Trns1) texture { Tx } }
 #break
#end
//**********************************************************************************
#local Fn=0; //11
#if(Fn>0)
 object { Square_seg pigment { Pc } translate <0,47,-1/5> }
 #if(Fn>12) object { Tdisp("Cissoid curve",0,7,Trns0-80*x) texture { Tc } } #end
 object { Square_seg pigment { Pc } translate <0,47,-1/5> rotate 180*z }
#end
#switch(Fn)
 #case(11)
  object { Tdisp("Cissoid of Diocles",1,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",0.5/40,<-pi/2,pi/2-1/40,1/40>,0,Fn) texture { Lc } scale 40 }
  object { Tdisp("r(t)=1/cos(t)-cos(t)  ( -pi/2<t<pi/2 )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(12)
  object { Tdisp("Right strophoid",1,8,Trns0) texture { Tx } }
  union { Plane_line("Pol",0.5/30,<-pi/2,3*pi/2-1/20,1/30>,0,Fn) texture { Lc } scale 30 }
  object { Tdisp("r(t)=1/cos(t)-tan(t)  ( -pi/2<t<3*pi/2 )",0.41,8,Trns1) texture { Tx } }
 #break
 #case(13)
  union { Plane_line("Pol",0.5/20,<-1.2,1.2,1/20>,0,Fn) texture { Lc } scale 20 }
  object { Tdisp("r(t)=2*sin(3*t)-tan(t)  ( -1.2<t<1.2 )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(14)
  union { Plane_line("Pol",0.5/20,<-pi,pi,1/20>,0,Fn) texture { Lc } scale 20 }
  object { Tdisp("r(t)=sinh(t)^4-exp(t)  ( -pi<t<pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(15)
  union { Plane_line("Pol",0.5/10,<-3*pi,pi/2,1/10>,0,Fn) texture { Lc } scale 10 }
  object { Tdisp("r(t)=exp(t)-cosh(t)^1/3  ( -3*pi<t<pi/2 )",0.42,8,Trns1) texture { Tx } }
 #break
#end
//----------------------------------------------------------------------------------
#local Fn=0;
#if(Fn>0)
 object { Square_seg pigment { Pc } translate <0,47,-1/5> }
 object { Tdisp("Conchoid curve",0,7,Trns0-80*x) texture { Tc } }
 object { Square_seg pigment { Pc } translate <0,47,-1/5> rotate 180*z }
#end
#switch(Fn)
 #case(21)
  object { Tdisp("Conchoid of Nicomedes",0,8,Trns0) texture { Tx } }
  object { Tdisp("Straight line",1,8,Trns0+<-21.3,-15,0>) texture { Ts } }
  union { Plane_line("Pol",0.5/20,<-pi/2,pi/2-1/20,1/20>,0,Fn) texture { Lc } scale 20 }
  union { Plane_line("Pol",0.5/20,<pi/2+1/20,3*pi/2-1/20,1/20>,0,Fn) texture { Lc } scale 20 }
  object { Tdisp("r(t)=1/cos(t)-K , K=3 , ( -pi/2<t<3*pi/2 )",0.415,8,Trns1) texture { Tx } }
 #break
 #case(22)
  object { Edisp("Limacon of Pascal",<5.74,-1.0,-21.28,0.4>,0,8,Trns0+10*x) texture { Tx } }
  object { Tdisp("Circle",0,8,Trns0+<-52,-15,0>) texture { Ts } }
  union { Plane_line("Pol",0.5/25,<-pi,pi,1/25>,0,Fn) texture { Lc } scale 25 }
  object { Tdisp("r(t)=A*cos(t)-K , A=2,K=1 , ( -pi<t<pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(23)
  object { Tdisp("Ellipse",0,8,Trns0+<55,-15,0>) texture { Ts } }
  union { Plane_line("Pol",0.5/20,<-pi,pi,1/20>,0,Fn) texture { Lc } scale 20 }
  object { Tdisp("r(t)=1/(1-e*cos(t))-K , e=3/4,K=3 , ( -pi<t<pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(24)
  object { Tdisp("Hyperbola",0,8,Trns0+<-67.5,-15,0>) texture { Ts } }
  union { Plane_line("Pol",0.5/20,<pi/4,7*pi/4,1/20>,0,Fn) texture { Lc } scale 20 }
  object { Tdisp("r(t)=1/(1-e*cos(t))-K , e=5/4,K=3 , ( pi/4<t<7*pi/4 )",0.42,7.6,Trns1) texture { Tx } }
 #break
 #case(25)
  object { Tdisp("Rose of 7 leaves",0,8,Trns0+<25,-15,0>) texture { Ts } }
  union { Plane_line("Pol",0.5/15,<-pi,pi,1/30>,0,Fn) texture { Lc } scale 15 }
  object { Tdisp("r(t)=sin(N*t)-K , N=7,K=2 , ( -pi<t<pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(26)
  object { Tdisp("Freeth's Nephroid",0,8,Trns0) texture { Tx } } #local Sc=18;
  union { Plane_line("Pol",0.5/Sc,<-2*pi,2*pi,1/Sc>,0,Fn) texture { Lc } scale Sc }
  object { Tdisp("r(t)=2*sin(t/2)-K , K=1 , ( -2*pi<t<2*pi )",0.42,8,Trns1) texture { Tx } }
 #break
#end
//**********************************************************************************
#local Fn=0; //31
#if(Fn>0)
 object { Square_seg pigment { Pc } translate <0,47,-1/5> }
 object { Square_seg pigment { Pc } translate <0,47,-1/5> rotate 180*z }
#end
#switch(Fn)
 #case(31)
  #local Sc=20;
  object { Tdisp("Trisectrix of Maclaurin",1,7,Trns0) texture { Tc } }
  union { Plane_line("Pol",0.5/Sc,<-1.3*pi,1.3*pi,2/Sc>,0,Fn) texture { Lc } scale Sc }
  object { Tdisp("r(t)=A/cos(t/3) , A=1 , ( -1.3*pi<t<1.3*pi )",0.42,8,Trns1) texture { Tx } }
 #break
 #case(32)
  #local Sc=50;
  object { Tdisp("Cochleoid",1,7,Trns0) texture { Tc } }
  union { Plane_line("Pol",0.5/Sc,<-pi,3*pi,5/Sc>,0,Fn) texture { Lc } scale Sc }
  object { Tdisp("r(t)=A*sin(t)/t , A=1 , ( -pi<t<3*pi )",0.42,8,Trns1) texture { Tx } }
 #break
#end
//**********************************************************************************