//**********************************************************************************
// Persistence Of Vision Ray tracer version 3.6.1c
// Plane curved line implicit function Scene file
// By S.Nishimura
//**********************************************************************************

global_settings { assumed_gamma 1.0 max_trace_level 5 }

camera { location -300*z look_at 0 angle 50 }

light_source{ <500,200,-1600> rgb 1 fade_distance 400 fade_power 1 parallel }

//**********************************************************************************
//create a TrueType text shape parameter Fm:1/2(center)
#macro Tdisp(Txt,Fm,Sc,Tr)
 #local Trns=Tr+<-Fm*strlen(Txt)*Sc/2,-Sc/3,0>;
 object { text { ttf "cyrvetic.ttf", Txt, 1, 0 }
  clipped_by { plane { z,1e-4 } } scale Sc translate Trns no_shadow }
#end
//**********************************************************************************
#macro Iso_T(V1,V2,Vc)
isosurface {
  function { fnc(x, y, z) }                 // alternative declared function
  contained_by { box { V1, V2 } }           // container shape
  #if(abs(Vc.x)>0.0) threshold Vc.x #end    // optional threshold value for isosurface [0.0]
  #if(abs(Vc.y)>1.1) max_gradient Vc.y #end // maximum gradient the function can have [1.1]
  open }                                    // remove visible container surface
#end // macro end
//**********************************************************************************
#macro Iso(V1,V2,Vc)
isosurface {
 #switch(Vc.z)
  #case(0) function { fnc(x, y, 3*z) } #break
  #case(1) function { fnc(x+z, y, z) } #break
  #case(2) function { fnc(x-z, y, z) } #break
  #case(3) function { fnc(x, y+z, z) } #break
  #case(4) function { fnc(x, y-z, z) } #break
  #case(5) function { fnc(x+z, y+z, z) } #break
  #case(6) function { fnc(x+z, y-z, z) } #break
  #case(7) function { fnc(x-z, y+z, z) } #break
  #case(8) function { fnc(x-z, y-z, z) } #break
  #else function { fnc(x, y, z) } #break
 #end
 contained_by { box { V1, V2 } }
 #if(abs(Vc.x)>0.0) threshold Vc.x #end
 max_gradient Vc.y
 open }
#end
//----------------------------------------------------------------------------------
#macro Iso_line(V1,V2,Vk,Fn) #local Vc=Surface_function(Vk.x,Vk.y,Fn); Iso(V1,V2,Vc) #end
//----------------------------------------------------------------------------------
#macro Iso_groupline(V1,V2,Vk,Fn)
 #local Lp=off; //off=0 , on=1
 #local K=Vk.x; #while(K<Vk.y)
  #local Vc=Surface_function(Lp,K,Fn); #local Lp=on; Iso(V1,V2,Vc)
 #local K=K+Vk.z; #end
#end
//**********************************************************************************
#macro Sgn(N) #if(N=0) #local Fg=0; #else #local Fg=N/abs(N); #end Fg #end
//**********************************************************************************
#macro Surface_function(Su,Sv,Func_type)
 #switch(Func_type)
 #case( 1) #declare fnc = function(x,y,z) { x/Su+y/Sv } #local F=<1,2.654,3>; #break //straight line
 #case( 2) #declare fnc = function(x,y,z) { abs(x)+abs(y) } #local F=<1,1.441,9>; #break //line
 #case( 3) #local R=1;
           #declare fnc = function(x,y,z) { pow(x-Su,2)+pow(y-Sv,2) } #local F=<pow(R,2),2.923,9>; #break //circle
 #case( 4) #declare fnc = function(x,y,z) { pow(x/Su,2)+pow(y/Sv,2) } #local F=<1,2.929,9>; #break //ellipse
 #case( 5) #local A=1/4;
           #declare fnc = function(x,y,z) { pow(y-Sv,2)-4*A*(x-Su) } #local F=<0,3.634,9>; #break //parabola
 #case( 6) #declare fnc = function(x,y,z) { pow(x/Su,2)-pow(y/Sv,2) } #local F=<1,3.5,9>; #break //hyperbola
 //group
 #case( 7) #local A=3/4;
           #if(Su=0) #declare fnc = function(x,y,z) { pow(x,3)-3*A*x*y+pow(y,3) } #end
           #local F=<Sv,10.5,3>; #break //folium of Descartes
 #case( 8) #local A=1;
           #if(Su=0) #declare fnc = function(x,y,z) { pow(pow(x,2)+pow(y,2)+pow(A,2),2)-4*pow(A,2)*pow(x,2) } #end
           #local F=<pow(Sv,4),64.531,3>; #break //oval of Cassini
 #end F
#end
//**********************************************************************************
background { color rgb <0.448, 0.889, 0.389> }
//**********************************************************************************
quadric{ <0,1,1>,<0,0,0>,<0,0,0>,-1 scale 5/16 pigment { color rgbt <1,1,0,0.5> } no_shadow } //x
quadric{ <1,0,1>,<0,0,0>,<0,0,0>,-1 scale 5/16 pigment { color rgbt <1,1,0,0.5> } no_shadow } //y
//**********************************************************************************
#local Square_seg = object {  plane { z,0 } clipped_by { plane { -y,0 } } hollow }
#local Trns0 = <0,95,-4/5>; #local Trns1 = <0,-96,-4/5>;
//**********************************************************************************
#local F0 = finish { phong 1 reflection 0.1 }
//----------------------------------------------------------------------------------
#local Ps = pigment { color rgb <0.2, 1.181, 1.288> }
#local Pc = pigment { color rgb <0.678, 0.017, 0.766> }
//----------------------------------------------------------------------------------
#local Lc = texture { pigment { color rgb <0.578, -0.083, 0.666> } finish { F0 } }
#local Tc = texture { pigment { color rgb <1.157, -0.237, 0.815> } finish { F0 } }
//**********************************************************************************
#local Fn=1; //1,2
#if(Fn>0)
 object { Square_seg pigment { Ps } translate <0,86.3,-1/6> }
 object { Tdisp("implicitly defined curve",0,10,Trns0-125*x) texture { Tc } }
 object { Tdisp("Straight line",-0.1,12,Trns0) pigment { Pc } }
 object { Square_seg pigment { Ps } translate <0,86.3,-1/6> rotate 180*z }
#end
#switch(Fn)
 #case( 1)
  #local Sc=60;
  object { Iso_line( -<2.0,0.7,0.6/Sc>, <2.5,1.44,0.6/Sc>, <1,1/2>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("x/A+y/B=1 , A=1,B=1/2 , ( -2.0<x<2.5,-0.7<y<1.5 )",0.485,11,Trns1) pigment { Pc } }
 #break
 #case( 2)
  #local Sc=60;
  object { Iso_line( -<1.1,1.1,3/Sc>, <1.1,1.1,3/Sc>, <0,0>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("abs(x)+abs(y)=1  ( -1<x<1,-1<y<1 )",0.5,11,Trns1) pigment { Pc } }
  union { Tdisp("=",0,11,Trns1+<11.5,-5,0>) Tdisp("=",0,11,Trns1+<25.5,-5,0>) pigment { Pc } }
  union { Tdisp("=",0,11,Trns1+<53.0,-5,0>) Tdisp("=",0,11,Trns1+<67.0,-5,0>) pigment { Pc } }
 #break
#end
//----------------------------------------------------------------------------------
#local Fn=0; //3~6
#if(Fn>0)
 object { Square_seg pigment { Ps } translate <0,86.3,-1/6> }
 object { Tdisp("implicitly defined curve",0,10,Trns0-125*x) texture { Tc } }
 object { Square_seg pigment { Ps } translate <0,86.3,-1/6> rotate 180*z }
#end
#switch(Fn)
 #case( 3)
  object { Tdisp("Circle",-0.1,12,Trns0) pigment { Pc } } #local Sc=60;
  object { Iso_line( -<0.75,0.75,3/Sc>, <1.25,1.25,3/Sc>, <1/4,1/4>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("(x-x1)^2+(y-y1)^2=r^2",0.52,11,Trns1+18*y) pigment { Pc } }
  object { Tdisp("<x1,y1>=<1/4,1/4>,r=1 , ( -0.75<x<1.25,-0.75<y<1.25 )",0.49,10,Trns1) pigment { Pc } }
  union { Tdisp("=",0,10,Trns1+<20.5,-4,0>) Tdisp("=",0,10,Trns1+<33.5,-4,0>) pigment { Pc } }
  union { Tdisp("=",0,10,Trns1+<85.5,-4,0>) Tdisp("=",0,10,Trns1+<98.5,-4,0>) pigment { Pc } }
 #break
 #case( 4)
  object { Tdisp("Ellipse",-0.1,12,Trns0) pigment { Pc } } #local Sc=60;
  object { Iso_line( -<1.4,1.1,3/Sc>, <1.4,1.1,3/Sc>, <4/3,1>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("(x/A)^2+(y/B)^2=1",0.52,11,Trns1+18*y) pigment { Pc } }
  object { Tdisp("A=4/3,B=1 , ( -1.4<x<1.4,-1.0<y<1.0 )",0.5,10,Trns1) pigment { Pc } }
  union { Tdisp("=",0,10,Trns1+<46,-4,0>) Tdisp("=",0,10,Trns1+<59,-4,0>) pigment { Pc } }
 #break
 #case( 5)
  object { Tdisp("Parabola",-0.1,12,Trns0) pigment { Pc } } #local Sc=60;
  object { Iso_line( -<0.6,1.44,4/Sc>, <1.5,1.44,4/Sc>, <-1/2,0>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("(y-y1)^2-4*A*(x-x1)=0",0.52,11,Trns1+18*y) pigment { Pc } }
  object { Tdisp("<x1,y1>=<-1/2,0>,A=1/4 , ( -0.5<x<1.5,-1.5<y<1.5 )",0.49,10,Trns1) pigment { Pc } }
  object { Tdisp("=",0,10,Trns1+<29.4,-4,0>) pigment { Pc } }
 #break
 #case( 6)
  object { Tdisp("Hyperbola",-0.1,12,Trns0) pigment { Pc } } #local Sc=60;
  object { Iso_line( -<1.8,1.44,4/Sc>, <1.8,1.44,4/Sc>, <1,1>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("(x/A)^2-(y/B)^2=1",0.49,11,Trns1+18*y) pigment { Pc } }
  object { Tdisp("A=1,B=1 , ( -1.8<x<1.8,-1.5<y<1.5 )",0.49,10,Trns1) pigment { Pc } }
 #break
#end
//----------------------------------------------------------------------------------
#local Fn=0; //7,8
#if(Fn>0)
 object { Square_seg pigment { Ps } translate <0,86.3,-1/6> }
 object { Tdisp("implicitly defined curve",0,10,Trns0-125*x) texture { Tc } }
 object { Square_seg pigment { Ps } translate <0,86.3-11,-1/6> rotate 180*z }
#end
#switch(Fn)
 #case( 7)
  object { Tdisp("Folium of Descartes",-0.1,11,Trns0) pigment { Pc } }
  union { Iso_groupline( -<2.5,1.44-0.18,1/60>, <2.0,1.44,1/60>, <-1,3/2,1/2>, Fn ) texture { Lc } scale 60 }
  object { Tdisp("x^3-3*A*x*y+y^3=h , A=3/4",0.49,11,Trns1+11*y) pigment { Pc } }
  object { Tdisp("(-2.5<x<2.0,-1.5<y<1.5) , -1.0<h<1.5 step 1/2",0.47,10,Trns1-y) pigment { Pc } }
  object { Tdisp("=",0,10,Trns1+<33,-6,0>) pigment { Pc } }
 #break
 #case( 8)
  object { Tdisp("Oval of Cassini",-0.1,11,Trns0) pigment { Pc } } #local Sc=55;
  union { Iso_groupline( -<2.1,1.5,1/Sc>, <2.1,1.5,1/Sc>, <1/2,2,1/4>, Fn ) texture { Lc } scale Sc }
  object { Tdisp("(x^2+y^2+A^2)^2-4*(A^2)*(x^2)=h^4 , A=1",0.52,11,Trns1+11*y) pigment { Pc } }
  object { Tdisp("(-2.1<x<2.1,-1.5<y<1.5) , 0.5<h<2.0 step 1/4",0.475,10,Trns1-y) pigment { Pc } }
  object { Tdisp("=",0,10,Trns1+<30.5,-6,0>) pigment { Pc } }
 #break
#end
//**********************************************************************************