//**********************************************************************************
// Persistence Of Vision Ray tracer version 3.6.1c
// Plane curved line Group Scene File
// By S.Nishimura
//**********************************************************************************

global_settings { assumed_gamma 1.0 max_trace_level 5 }

camera { location -200*z look_at 0 angle 50 }

light_source { <0,tan(radians(0))*800,-800 > color rgb 1 parallel point_at z shadowless }

//**********************************************************************************
//create a TrueType text shape Tdisp parameter Fm=1/2(Center)
#macro Tdisp(Txt,Fm,Sc,Tr)
 #local Trns=Tr+<-Fm*strlen(Txt)*Sc/2,-Sc/3,0>;
 object { text { ttf "cyrvetic.ttf", Txt, 1, 0 }
  clipped_by { plane { z,1e-4 } } scale Sc translate Trns no_shadow }
#end
//**********************************************************************************
#macro Edisp(Txt,Vc,Np,Ns,Nt)
#local Ctyp=asc(Txt)-asc("A")+1; #local Ks=Vc.t;
 #switch(Ctyp)
  #case(12)
   #local Symbol=object { Tdisp("5",0,1,0) clipped_by { plane { y,0.18 } } rotate -8*z }
  #break
  #case(13)
   #local Symbol=object { Tdisp(":",0,1,0) rotate 90*z }
  #break
  #case(16)
   #local Symbol=object { Tdisp(":",0,1,0) rotate 90*z }
  #break
 #end
 union {  
  object { Tdisp(Txt,Np,Ns,Nt) }
  object { Symbol translate <Vc.x,Vc.y,0>+Vc.z*Np*x+Nt/(Ks*Ns) scale Ks*Ns }
 }
#end
//**********************************************************************************
//Cornu's spiral clothoid
#macro Clothoid(Lr,V1)
 #local X=0; #local Y=0;
 #local T=V1.x; #while(T<V1.y)
  #local X=X+cos(pow(T,2)*pi/2)*V1.z; #local Y=Y+sin(pow(T,2)*pi/2)*V1.z;
  sphere { < X, Y> Lr } sphere { <-X,-Y> Lr }
 #local T=T+V1.z; #end
#end
//**********************************************************************************
//xy-plane Group asteroid
#macro Group_asteroid(Lr,V1,Vc,Fn)
 #local A=V1.y;
 #local N=Vc.x; #while(N<Vc.y)
  #local P1=Line_function(V1.x,Fn);
  #local Tp=V1.x; #while(Tp<V1.y)
   #local P2=Line_function(Tp+V1.z,Fn);
   cylinder { P1,P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end
   #local Ps=< P1.x,-P1.y>; #local Pe=< P2.x,-P2.y>;
   cylinder { Ps,Pe, Lr } #if(Tp<V1.y-V1.z) sphere { Pe, Lr } #end
   #local Ps=<-P1.x, P1.y>; #local Pe=<-P2.x, P2.y>;
   cylinder { Ps,Pe, Lr } #if(Tp<V1.y-V1.z) sphere { Pe, Lr } #end
   #local Ps=<-P1.x,-P1.y>; #local Pe=<-P2.x,-P2.y>;
   cylinder { Ps,Pe, Lr } #if(Tp<V1.y-V1.z) sphere { Pe, Lr } #end
   #local P1=P2;
  #local Tp=Tp+V1.z; #end
 #local N=N+Vc.z; #end
#end
//**********************************************************************************
//xy-plane Group line parameter Typ:Par=16+1,Fnc=6+14,(Equ=5+17),Pol=16+15
#macro Group_line(Typ,Lr,V1,Vc,Fn)
 #local Ctyp=asc(Typ)+asc(substr(strupr(Typ),2,1))-2*(asc("A")-1);
 #switch(Ctyp)
  #case(17)
   #local K=Vc.x; #while(K<Vc.y)
    #local P1=Line_function(V1.x,Fn);
    #local Tp=V1.x; #while(Tp<V1.y)
     #local P2=Line_function(Tp+V1.z,Fn);
     cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end #local P1=P2;
    #local Tp=Tp+V1.z; #end
   #local K=K+Vc.z; #end
  #break
  #case(20)
   #local K=Vc.x; #while(K<Vc.y)
    #local P1=< V1.x,Line_function(V1.x,Fn) >;
    #local Tp=V1.x; #while(Tp<V1.y)
     #local P2=< Tp+V1.z, Line_function(Tp+V1.z,Fn)>;
     cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end #local P1=P2;
    #local Tp=Tp+V1.z; #end
   #local K=K+Vc.z; #end
  #break
  #case(22)
   #local Fb=0; #local Y=V2.x; #while(Y<V2.y)
    #local Spx=V1.x-V1.z; #local X=Spx; #while(X<V1.y)
     #local F=Line_function(<X,Y>,Fn);
     #if(X!=Spx & F*Fb<0) sphere { <X,Y> Lr } #end #local Fb=F;
    #local X=X+V1.z; #end
   #local Y=Y+V2.z; #end
  #break
  #case(31)
   #local K=Vc.x; #while(K<Vc.y)
   #local P1=Line_function(V1.x,Fn)*< cos(V1.x), sin(V1.x) >;
   #local Tp=V1.x; #while(Tp<V1.y)
    #local P2=Line_function(Tp+V1.z,Fn)*< cos(Tp+V1.z), sin(Tp+V1.z) >;
    #if(P1.x!=P2.x & P1.y!=P2.y)
     cylinder { P1, P2, Lr } #if(Tp<V1.y-V1.z) sphere { P2, Lr } #end
    #end #local P1=P2;
   #local Tp=Tp+V1.z; #end
   #local K=K+Vc.z; #end
  #break
 #end
#end // macro end
//**********************************************************************************
#macro Sgn(N) #if(N=0) #local Fg=0; #else #local Fg=N/abs(N); #end Fg #end
//----------------------------------------------------------------------------------
#macro Sgnz(N) #if(N=0) #local Fg=0; #else #local Fg=N/abs(N)-1; #end Fg/2*1e-8 #end
//----------------------------------------------------------------------------------
#macro Epsz(N) #if(N=0) #local N=1e-8; #end N #end
//**********************************************************************************
#macro Line_function(Tp,Fn)
 #switch(Fn)
  #case( 1) #local F=K*(cosh(Tp/K)-1)-(K-1)/K; #break //Catenary
  #case( 2) #local A=1; #local F=pow(A,3)/(pow(A,2)+pow(Tp,2)); #break //witch of Agnesi
  #case( 3) #local A=2; #local F=A*acosh(A/Epsz(Tp))-sqrt(pow(A,2)-pow(Tp,2)); #break //Tractrix
  #case( 4) #local A=1; #local R1=2*sin(Tp/2); #local K=1; #local F=A*(R1-K); #break //Freeth's Nephroid
  #case( 5) #local F=< pow(Tp,2), pow(Tp,3) >; #break //semi-cubical parabola
  #case( 6) #local F=< sin(Tp), cos(Tp)*sin(Tp) >; #break //Lemniscate of Gerono
  #case( 7) #local A=3/2; #local X=A*acosh(A/abs(Tp))-sqrt(pow(A,2)-pow(Tp,2)); #local F=< Sgn(Tp)*X, abs(Tp) >; #break //Tractrix
  #case( 8) #local A=1; #local F=2*A*<pow(Tp,2),pow(Tp,3)>/(pow(Tp,2)+1); #break //Cissoid of Diocles
  //group
  #case(11) #local P=pow(A,N)-pow(Tp,N); #local F=< Tp, Sgn(P)*pow(abs(P),1/N) >; #break //asteroid
  #case(12) #local R=(cos(Tp)+K); #local F=R; #break //limacon of Pascal
  #case(13) #local A=1; #local R=A/Epsz(cos(Tp))+K; #local F=R; #break //conchoid of Nicomedes
  #case(14) #local F=<K*cos(Tp),(Tl-K)*sin(Tp)>; #break //trammel
 #end F
#end
//**********************************************************************************
background { color rgb <-0.393, 0.848, 0.294>  }
//**********************************************************************************
quadric{ <0,1,1>,<0,0,0>,<0,0,0>,-1 scale 1/4 pigment { color rgbt <1,1,0,0.5> } } //x
quadric{ <1,0,1>,<0,0,0>,<0,0,0>,-1 scale 1/4 pigment { color rgbt <1,1,0,0.5> } } //y
//**********************************************************************************
#local Square_seg = object {  plane { z,0 } clipped_by { plane { -y,0 } } hollow }
#local Trns0 = <0,60,-4/5>; #local Trns1 = <0,-57,-4/5>; #local Trns2 = <0,-64,-4/5>;
//**********************************************************************************
#local F0 = finish { specular 0.1 reflection 0.1 }
#local F3 = finish { metallic
       ambient 0.2 diffuse 0.35 specular 0.85 roughness 0.01 reflection 0.45 brilliance 1.5 }
//----------------------------------------------------------------------------------
#local Ps = pigment { color rgb <0.910, 1.011, 0.3> }
#local Lx = pigment { color rgb <0.371, 0.093, 0.303> }
//----------------------------------------------------------------------------------
#local Tx = texture { pigment { color rgb <-0.296, 0.142, 0.047> } }
#local Tc = texture { pigment { color rgb <0.578, -0.083, 0.666> } }
#local Lc = texture { pigment { color rgb <0.553, -0.327, 0.672> } finish { F0 } }
//**********************************************************************************
#local Fn=1; //1,2,4,6
#if(Fn>0)
 object { Square_seg pigment { Ps } translate <0,52,-1/5> }
 object { Square_seg pigment { Ps } translate <0,52,-1/5> rotate 180*z }
#end
#switch(Fn)
 #case( 1)
  object { Tdisp("Catenary",0,8,Trns0) texture { Tc } } #local Sc=30;
  union { Group_line("Fnc",0.5/Sc,<-3.1,3.1,1/Sc>,<1,4,1/2>,Fn) texture { Lc } scale Sc }
  object { Tdisp("y=K*(cosh(x/K)-1)-(K-1)/K  ( -3.1<x<3.1 ) , 1<K<4,step 1/2",0.452,6.8,Trns1-4*y) texture { Tc } }
  object { Tdisp("=",0,6.8,Trns1+<45.5,-6.8,0>) texture { Tc } }
 #break
 #case( 2)
  object { Tdisp("Witch of Agnesi",0,8,Trns0) texture { Tc } } #local Sc=30;
  union { Group_line("Fnc",0.5/Sc,<-3.1,3.1,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("y=A^3/(A^2+x^2) , A=1 , ( -3.1<x<3.1 )",0.48,8,Trns1-4*y) texture { Tc } }
 #break
 #case( 3)
  object { Tdisp("Tractrix",1,8,Trns0) texture { Tx } } #local Sc=30;
  #local Graph=union { Group_line("Fnc",0.5/Sc,<0,2-0.04,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Graph } sphere{ <2,0> 0.5/Sc texture { Lc } scale Sc } object { Graph rotate 180*x }
  object { Tdisp("y=A*acosh(A/x)-sqrt(A^2-x^2) , A=2 , ( 0<x<A )",0.46,8,Trns1-4*y) texture { Tx } }
 #break
 #case( 4)
  object { Tdisp("Freeth's Nephroid",0,8,Trns0) texture { Tc } } #local Sc=20;
  union { Group_line("Pol",0.5/Sc,<-2*pi,2*pi,1/20>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("r(t)=A*(2*sin(t/2)-K) , A=1 , K=1 , ( -2*pi<t<2*pi )",0.41,7,Trns1-4*y) texture { Tc } }
 #break
 #case( 5)
  object { Tdisp("Semi-cubical parabola",1,8,Trns0) texture { Tx } } #local Sc=30;
  union { Group_line("Par",0.5/Sc,<-pi,pi,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("P(t)=< t^2, t^3 >  ( -pi<t<pi )",0.44,8,Trns1-4*y) texture { Tx } }
 #break
 #case( 6)
  object { Tdisp("Lemniscate of Gerono",0,8,Trns0) texture { Tc } } #local Sc=60;
  union { Group_line("Par",0.5/Sc,<-pi,pi,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("P(t)=< sin(t), cos(t)*sin(t) >  ( -pi<t<pi )",0.42,8,Trns1-4*y) texture { Tc } }
 #break
 #case( 7)
  object { Tdisp("Tractrix",0,8,Trns0) texture { Tc } } #local Te=3/2; #local Sc=30;
  union { Group_line("Par",0.5/Sc,<-Te+0.03,-1e-2,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  sphere{ <0,Te> 0.5/Sc texture { Lc } scale Sc }
  union { Group_line("Par",0.5/Sc,<1e-2,Te-0.03,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("P(t)=< A*acosh(A/t)-sqrt(A^2-t^2), t > , A=3/2 , ( 0<t<A )",0.44,7,Trns1-4*y) texture { Tc } }
 #break
 #case( 8)
  object { Tdisp("Cissoid of Diocles",1,8,Trns0) texture { Tx } } #local Sc=30;
  union { Group_line("Par",0.5/Sc,<-pi,pi,1/Sc>,<0,1,1>,Fn) texture { Lc } scale Sc }
  object { Tdisp("P(t)=2*A*<t^2,t^3>/(t^2+1) , A=1 , ( -pi<t<pi )",0.45,8,Trns1-4*y) texture { Tx } }
 #break
#end
//**********************************************************************************
#local Fn=0; //10
#if(Fn>0)
  object { Square_seg pigment { Ps } translate <0,47,-1/5> }
  object { Tdisp("Clothoid",2.8,7,Trns0-3*y) texture { Tc } }
  object { Tdisp("  Cornu's spiral",0,8,Trns0-3*y) texture { Tx } }
  union { Clothoid(1/240,<0,9,1/200>) texture { Lc } scale 70 }
  object { Square_seg pigment { Ps } translate <0,47,-1/5> rotate 180*z }
  object { Tdisp("x(t)=x(t)+cos(pi*t^2/2)*dt , y(t)=y(t)+sin(pi*t^2/2)*dt",0.42,7,Trns1) texture { Tx } }
  object { Tdisp("x(0)=0 , y(0)=0 , dt=1/200 , ( 0<t<9 )",0.45,6,Trns2-y) texture { Tx } }
#end
//**********************************************************************************
#local Fn=0; //12,13
#if(Fn>0)
 object { Square_seg pigment { Ps } translate <0,54,-2/5> }
 object { Square_seg pigment { Ps } translate <0,54,-2/5> rotate 180*z }
#end
#switch(Fn)
 #case(11)
  object { Tdisp("  Super ellipse",0,8,Trns0) texture { Tc } }
  union { Group_asteroid(1/60,<0,3,1/10>,<0.4,3,1/4>,Fn) texture { Lc } scale 15 }
  object { Tdisp("x^N+y^N=A^N , A=3 , ( 0<x<3 ) , 0.4<N<3,step 1/4",0.5,7,Trns1-4*y) texture { Tc } }
  object { Tdisp("=",0,7,Trns1+<38.5,-7,0>) texture { Tc } }
 #break
 #case(12)
  object { Edisp("Limacon of Pascal",<5.74,-1.0,-21.28,0.4>,0,8,Trns0+5*x) texture { Tc } }
  union { Group_line("Pol",1/90,<-pi,pi,1/30>,<0,4,1/2>,Fn) texture { Lc } scale 30 }
  object { Tdisp("r(t)=cos(t)+K  ( -pi<t<pi ) , 0<K<4,step 1/2",0.45,7,Trns1-4*y) texture { Tc } }
  object { Tdisp("=",0,7,Trns1+<20.0,-7,0>) texture { Tc } }
 #break
 #case(13)
  object { Tdisp(" Conchoid of Nicomedes",0,8,Trns0) texture { Tc } }
  union { Group_line("Pol",1/80,<-pi/2,pi/2-1/15,1/15>,<0,3,1/2>,Fn) texture { Lc } scale 25 }
  union { Group_line("Pol",1/80,<pi/2+1/15,3*pi/2-1/15,1/15>,<0,3,1/2>,Fn) texture { Lc } scale 25 }
  object { Tdisp("r(t)=A/cos(t)+K , A=1 , ( -pi/2<t<3*pi/2 ) , 0<K<3,step 1/2",0.44,6.8,Trns1-4*y) texture { Tc } }
  object { Tdisp("=",0,6.8,Trns1+<45.1,-6.8,0>) texture { Tc } }
 #break
 #case(14)
  object { Tdisp("Concentric ellipse",1/2,8,Trns0+5*x) texture { Tc } }
  #local Tl=3; // trammel length:Tl , transfer point:K
  union { Group_line("Par",1/80,<-pi,pi,1/20>,<0,Tl+1/4,1/4>,Fn) texture { Lc } scale 20 }
  object { Tdisp("P(t)=<K*cos(t),(Tl-K)*sin(t)> , Tl=3 , ( -pi<t<pi ) , 0<K<3,step 1/4",0.43,6.2,Trns1-4*y) texture { Tc } }
  object { Tdisp("=",0,6.2,Trns1+<50.35,-6.6,0>) texture { Tc } }
  object { Tdisp("=",0,6.2,Trns1+<59.45,-6.6,0>) texture { Tc } }
 #break
#end
//**********************************************************************************