//-----------------------------------------------------------------------------------
// RGB-DotMatrix J[LN^@\eXgvO  PIC 18F23K22p@
// Programmed by  Mintaro kanda  CNbN 64MHz
//   for CCS-C RpC
//     2019/12/3(Tue)
// @C0:out Enable iLowONj   C1:Data Latch
// @C3:SPI Clock
//-----------------------------------------------------------------------------------
#include <18F23K22.h>
#fuses INTRC_IO,NOWDT,NOPROTECT,BROWNOUT,PUT,NOMCLR,NOCPD
#fuses NOIESO,NOFCMEN
#use delay (clock=64000000)//clock 64MHz
#use fast_io(a)
#use fast_io(b)
#use fast_io(c)
//        
const int data[32][4][3]={ //IWiLN^[EJ[f[^
 {{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0}},
  {{0xe0,0x0,0x0},{0x7,0x0,0x0},{0x0,0xc0,0x0},{0x0,0x7,0x0}},
  {{0xf0,0x0,0x0},{0xf,0x0,0x0},{0x0,0xe0,0x0},{0x0,0xf,0x0}},
  {{0xf8,0x0,0x0},{0x1f,0x0,0x0},{0x0,0xf8,0x0},{0x0,0x1f,0x0}},
  {{0xfc,0x0,0x0},{0x3f,0x0,0x0},{0x0,0xfc,0x0},{0x0,0x3f,0x0}},
  {{0xfc,0x18,0x18},{0x3f,0x6,0x6},{0x18,0xfc,0x18},{0x6,0x3f,0x6}},
  {{0xfe,0x3c,0x3c},{0x7f,0xf,0xf},{0x3c,0xfe,0x3c},{0xf,0x7f,0xf}},
  {{0xe6,0x24,0x24},{0x79,0x9,0x9},{0x24,0xe6,0x24},{0x9,0x79,0x9}},
  {{0xfe,0x3c,0x3c},{0x7f,0xf,0xf},{0x3c,0xfe,0x3c},{0xf,0x7f,0xf}},  
  {{0xfe,0x18,0x18},{0x7f,0x6,0x6},{0x18,0xfe,0x18},{0x6,0x7f,0x6}},
  {{0xfe,0x0,0x0},{0x7f,0x0,0x0},{0x0,0xfe,0x0},{0x0,0x7f,0x0}},
  {{0xfe,0x0,0x0},{0x7f,0x0,0x0},{0x0,0xfe,0x0},{0x0,0x7f,0x0}},
  {{0xfe,0x20,0x20},{0x7f,0x2,0x2},{0x20,0xde,0x0},{0x2,0x7d,0x0}},
  {{0xfc,0xc0,0xc0},{0x3f,0x1,0x1},{0xc0,0x3c,0x0},{0x1,0x3e,0x0}},
  {{0xf8,0x0,0x0},{0x1f,0x0,0x0},{0x0,0xf0,0x0},{0x0,0x1f,0x0}},
  {{0xe0,0x0,0x0},{0xf,0x0,0x0},{0x0,0xe0,0x0},{0x0,0x7,0x0}},
  {{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0}},
  {{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0},{0x0,0x0,0x0}},
  {{0xe4,0xe0,0x0},{0x17,0x7,0x0},{0x4,0xe0,0xe0},{0x10,0x7,0x7}},
  {{0xf8,0xf0,0x0},{0xf,0x7,0x0},{0x8,0xf0,0xf0},{0x8,0x7,0x7}},
  {{0xfc,0xec,0x0},{0x1f,0x1b,0x0},{0x10,0xec,0xec},{0x4,0x1b,0x1b}},
  {{0xfc,0xfc,0x18},{0x3f,0x3f,0x6},{0x18,0xfc,0xfc},{0x6,0x3f,0x3f}},
  {{0xe6,0xe6,0x24},{0x39,0x39,0x1},{0x24,0xe6,0xe6},{0x9,0x39,0x39}},
  {{0xe6,0xe6,0x24},{0x79,0x79,0x9},{0x24,0xe6,0xe6},{0x9,0x79,0x79}},
  {{0xfe,0xfe,0x3c},{0x7f,0x7f,0xf},{0x3c,0xfe,0xfe},{0xf,0x7f,0x7f}},
  {{0xfe,0xfe,0x18},{0x7f,0x7f,0x6},{0x18,0xfe,0xfe},{0x6,0x7f,0x7f}},
  {{0xfe,0xfe,0x0},{0x7f,0x7f,0x0},{0x0,0xfe,0xfe},{0x0,0x7f,0x7f}},
  {{0x3e,0x3e,0x0},{0x7e,0x7e,0x0},{0x0,0x3e,0x3e},{0x0,0x7e,0x7e}},
  {{0xdc,0xdc,0x0},{0x3d,0x3d,0x0},{0x0,0xde,0xde},{0x0,0x3d,0x3d}},
  {{0xfc,0xfc,0x0},{0x3f,0x3f,0x0},{0x0,0xfc,0xfc},{0x0,0x3f,0x3f}},
  {{0xf8,0xf8,0x0},{0x1f,0x1f,0x0},{0x0,0xf8,0xf8},{0x0,0xf,0xf}},
  {{0xf0,0xf0,0x0},{0xf,0xf,0x0},{0x0,0xe0,0xe0},{0x0,0x7,0x7}} };

void main()
  {
    int i,j,k,n,od;
    int data1[3],data2[3];
    set_tris_a(0x0);
    set_tris_b(0x0);
    set_tris_c(0x0);
    setup_adc_ports(NO_ANALOGS);
    setup_oscillator(OSC_64MHZ);
    output_a(0);
    output_b(0);
    output_c(0);
    
    while(1){
      for(k=0;k<16;k++){//Line_[v
           output_a(k);
           output_low(PIN_C1);//f[^M
           for(j=0;j<4;j++){//SubÑf[^o
               for(n=0;n<3;n++){
                 data1[n]=data[k][j][n];
                 data2[n]=data[k+16][j][n];
               }
               for(i=8;i>0;i--){//1bitô߂̃[v
                  od=( (data1[0] & 0x1)    | (data2[0] & 0x1)<<3
                     | (data1[1] & 0x1)<<1 | (data2[1] & 0x1)<<4
                     | (data1[2] & 0x1)<<2 | (data2[2] & 0x1)<<5 );
                  output_b(od);
                   //SPINbN
                   output_high(PIN_C3);
                   for(n=0;n<3;n++){
                       data1[n]>>=1;data2[n]>>=1;
                   }
                   output_low(PIN_C3);
               }
           }
        output_high(PIN_C1);//f[^b`
        output_low(PIN_C0);//_
        delay_us(500); //  1/2000b_ 
        output_high(PIN_C0);//
      }
    }
}
