#!/usr/bin/python
# -*- coding: utf-8  -*-
#

import pygame

# グローバル変数
sw = 320
sh = 240
chr_w = 8
chr_h = 8
chr_xn = sw / chr_w
chr_yn = sh / chr_h

block_side = 4
block_top = 4
block_bottom = block_top + 10

C_SPACE = 0
C_KABE = 1
C_BLOCK = 2

NOMOVE = 0
LEFT = 1
RIGHT = 2

#ブロック配列の作成
def make_blocks():
	l = []
	for y in range(chr_yn):
		l_x = []
		for x in range(chr_xn):
			if x == 0 or x == chr_xn - 1 or y == 0:
				l_x.append(C_KABE)
			elif x >= block_side and x < chr_xn - block_side:

				if y >= block_top and y <= block_bottom:
					l_x.append(C_BLOCK)
				else:
					l_x.append(C_SPACE)
					
			else:
				l_x.append(C_SPACE)

		l.append(l_x)

	return l

# ブロックの当たり判定と処理
def block_check(blks, x, y, s, score, se):
	if x < 0 or x >= chr_xn:
		return s, score

	if y < 0 or y >= chr_yn:
		return s, score
	
	# 壁 or ブロックに当たった
	if blks[y][x] != C_SPACE:
		se.play()
		s = 0 - s
		if blks[y][x] == C_BLOCK:
			score += 100
			blks[y][x] = C_SPACE

	return s, score
	


#ループ
def loop(screen):
	score = 0
	old_score = -1

	ball_x = (sw / 2) - (chr_w / 2)
	ball_y = (sh / 2) + (chr_h * 4)

	ball_step = 1
	ball_ys = ball_step
	ball_xs = 0 - ball_step
	bar_x = (sw/2) - (chr_w * 2)
	bar_y = sh - (chr_h * 2)
	bar_step = 4
	bar_left = chr_w
	bar_right = sw - (chr_w * 5)
	
	bar_act = NOMOVE
	
	white = (255, 255, 255)
	black = (0, 0, 0)
	
	# 画像読み出し＆初期化
	blks = make_blocks()
	font = pygame.font.SysFont("None", 24 )

	pic_ball  = pygame.image.load("ball.png").convert_alpha()
	pic_block = pygame.image.load("block01.png").convert()
	pic_bar   = pygame.image.load("block02.png").convert()
	pic_kabe  = pygame.image.load("block03.png").convert()
	
	
	# 効果音読み出し
	wav_ping = pygame.mixer.Sound("ping.wav")
	wav_pong = pygame.mixer.Sound("pong.wav")
	
	# 音楽再生
	pygame.mixer.music.load("bgm.wav")
	pygame.mixer.music.play(-1)

	# 時間
	clock = pygame.time.Clock()
	
	# 終了フラグ
	done = False
		
	while not done:
		for event in pygame.event.get():
			# ウインドウのクローズボタンが押された為、終了
			if event.type == pygame.QUIT:
				done = True
			# キーが押された
			elif event.type == pygame.KEYDOWN:			
				# ESCキーで終了
				if event.key == pygame.K_ESCAPE:
					done = True
				
				if event.key == pygame.K_LEFT:
					bar_act = LEFT

				if event.key == pygame.K_RIGHT:
					bar_act = RIGHT
			# キーが離された
			elif event.type == pygame.KEYUP:
				if event.key == pygame.K_LEFT and bar_act == LEFT:
					bar_act = NOMOVE
					
				if event.key == pygame.K_RIGHT and bar_act == RIGHT:
					bar_act = NOMOVE
		# ボール移動
		ball_x += ball_xs
		ball_y += ball_ys
		
		# ボールが画面外なので終了
		if ball_x < 0 or ball_x > sw or ball_y < 0 or ball_y > sh:
			done = True
			break
		
		#　ボール中心位置
		ball_yc = ball_y + (chr_h / 2)
		ball_xc = ball_x + (chr_w / 2)
		
		# バーに当たっている
		if ball_y + chr_h >= bar_y:
			if ball_xc >= bar_x and ball_xc < (bar_x + chr_w * 4):
				wav_ping.play()
				ball_ys = 0 - ball_step
				
				# 左側は左に返す
				if ball_xc < bar_x + chr_w * 2:
					ball_xs = 0 - ball_step
				# 右側は右に返す
				if ball_xc >= bar_x + chr_w * 2:
					ball_xs = ball_step

		
		# ブロックの当たり判定処理
		y = ball_y / chr_h
		x = ball_xc / chr_w

		ball_ys, score = block_check(blks, x, y, ball_ys, score, wav_pong)
		ball_ys, score = block_check(blks, x, y + 1, ball_ys, score, wav_pong)
		
		y = ball_yc / chr_h
		x = ball_x / chr_w
		
		ball_xs, score = block_check(blks, x, y, ball_xs, score, wav_pong)
		ball_xs, score = block_check(blks, x + 1, y, ball_xs, score, wav_pong)
			
		
		# 動きの計算
		if bar_act == LEFT:
			if bar_x - bar_step >= bar_left:
				bar_x -= bar_step
		
		if bar_act == RIGHT:
			if bar_x + bar_step <= bar_right:
				bar_x += bar_step


		# 画面書き換え
		screen.fill(white)

		for y in range(chr_yn):
			for x in range(chr_xn):
				cord = (x * chr_w, y * chr_h)
				if blks[y][x] == C_BLOCK:
					screen.blit(pic_block, cord)
				if blks[y][x] == C_KABE:
					screen.blit(pic_kabe, cord)
		
		screen.blit(pic_ball, (ball_x, ball_y))
		
		for i in range(4):
			screen.blit(pic_bar, (bar_x + (i * chr_w), bar_y))

		
		# スコア表示
		if old_score != score:
			old_score = score
			score_str = "SCORE : %6d" % score
			
			score_shadow = font.render(score_str, True , black)
			score_surf = font.render(score_str, True , white)


		screen.blit(score_shadow, (1,1))
		screen.blit(score_surf, (0,0))
		
		pygame.display.flip()
		
		# 60fpsに制限
		clock.tick(60)

	
	# ゲームオーバー
	pygame.mixer.music.stop()
	msg_str = "GAME OVER"
	msg_s = font.render(msg_str, True, black)
	msg = font.render(msg_str, True, white)
	
	msg_w, msg_h = msg.get_size()
	
	msg_x = (sw / 2) - (msg_w / 2)
	msg_y = (sh / 2) - (msg_h / 2)

	screen.blit(msg_s, (msg_x + 1, msg_y + 1))
	screen.blit(msg, (msg_x, msg_y))
	
	pygame.display.update()
	pygame.time.delay(1000)
		


# メイン
pygame.init()
screen = pygame.display.set_mode([sw, sh])
pygame.mouse.set_visible(False)


loop(screen)


