//
//  HelloWorldLayer.m
//  test
//
//  Created by 久保島 祐磨 on 12/07/07.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"
#import "NewScene.h"

// HelloWorldLayer implementation
@implementation HelloWorldLayer

+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
-(id) init
{
	// always call "super" init
	// Apple recommends to re-assign "self" with the "super" return value
	if( (self=[super init])) {
		
		// create and initialize a Label
		//CCLabelTTF *label = [CCLabelTTF labelWithString:@"Hello World" fontName:@"Marker Felt" fontSize:64];

		// ask director the the window size
		CGSize size = [[CCDirector sharedDirector] winSize];
		
		// sample.pngを表示します
		CCSprite* sampleSprite = [CCSprite spriteWithFile:@"sample.png"];
		[self addChild:sampleSprite];
		//sampleSprite.position = CGPointMake(size.width / 2, size.height / 2);
		
		//CCLabelTTF *label = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"W:%.2f, H:%.2f", size.width, size.height] fontName:@"Marker Felt" fontSize:40];
		
		CCLabelBMFont *label = [CCLabelBMFont labelWithString:@"Hello World" fntFile:@"HelloWorld.fnt"];
	
		// position the label on the center of the screen
		label.position =  ccp( size.width /2 , size.height/2 );
		
		// add the label as a child to this Layer
		[self addChild: label];
		
		// NewSceneに遷移する為のメニューを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:40];
		CCMenuItemFont *item = [CCMenuItemFont itemFromString:@"NewSceneへ" block:^(id sender) {
			[[CCDirector sharedDirector] replaceScene:[NewScene scene]];
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(size.width / 2, size.height / 2 - 60);
		// メニューをselfレイヤーに追加します
		[self addChild:menu];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}
@end
