//
//  HelloWorldLayer.m
//  test2
//
//  Created by 久保島 祐磨 on 12/07/13.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// HelloWorldLayer implementation
@implementation HelloWorldLayer

+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// CCRotateToを適用するラベルを作ります
		CCLabelTTF*	label1 = [CCLabelTTF labelWithString:@"RotateTo" fontName:@"Marker Felt" fontSize:30];
		label1.position = CGPointMake(winSize.width / 4, winSize.height / 2);
		[self addChild:label1];
		label1.rotation = 45;
		
		// CCRotateByを適用するラベルを作ります
		CCLabelTTF* label2 = [CCLabelTTF labelWithString:@"RotateBy" fontName:@"Marker Felt" fontSize:30];
		label2.position = CGPointMake(winSize.width - winSize.width / 4, winSize.height / 2);
		[self addChild:label2];
		label2.rotation = 45;
		
		// アクションを開始する為のメニューボタンを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:30];
		CCMenuItemFont *item = [CCMenuItemFont itemFromString:@"Action" block:^(id sender) {
			// CCRotateToを適用します
			CCRotateTo* rotateTo = [CCRotateTo actionWithDuration:5 angle:180];
			[label1 runAction:rotateTo];
			
			// CCRotateByを適用します
			CCRotateBy* rotateBy = [CCRotateBy actionWithDuration:5 angle:180];
			[label2 runAction:rotateBy];
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(winSize.width / 2, 60);
		[self addChild:menu];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}
@end
