//
//  NewScene.m
//  test
//
//  Created by 久保島 祐磨 on 12/07/13.
//  Copyright 2012年 株式会社 ICT Fractal. All rights reserved.
//

#import "NewScene.h"
#import "HelloWorldLayer.h"

@implementation NewScene

+(CCScene *) scene
{
	CCScene *scene = [CCScene node];
	NewScene *layer = [NewScene node];
	[scene addChild:layer];
	
	return scene;
}

-(id) init
{
	if (self = [super init]) {
		// ==== レイヤーA （sceneメソッドで生成したレイヤーを用います。つまりselfですね。）====
		// レイヤーAを生成します
		CCLayer* layerA = [CCLayer node];
		// レイヤーAをNewSceneレイヤーに追加します
		[self addChild:layerA];
		// sample.pngをスプライトオブジェクトに読み込みます
		CCSprite* sampleSprite = [CCSprite spriteWithFile:@"sample.png"];
		// スプライトオブジェクトを画面の中心に配置します
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		sampleSprite.position = CGPointMake(winSize.width / 2, winSize.height / 2);
		// スプライトオブジェクトをレイヤーAに追加します
		[layerA addChild:sampleSprite];
		// 回転アニメーションオブジェクトを生成します
		id rotate = [CCRotateBy actionWithDuration:10 angle:360];
		id roop = [CCRepeatForever actionWithAction:rotate];
		// レイヤーAにアニメーションを適用します
		[layerA runAction:roop];
		
		// ==== レイヤーB ====
		// レイヤーBを生成します
		CCLayer* layerB = [CCLayer node];
		// レイヤーBをNewSceneレイヤーに追加します
		[self addChild:layerB];
		// 前の画面に戻るメニューを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:40];
		CCMenuItemFont* item = [CCMenuItemFont itemWithString:@"戻る" block:^(id sender) {
			[[CCDirector sharedDirector] replaceScene:[HelloWorldLayer scene]];
		}];
		
		// イメージメニューを作ります
		CCMenuItemImage *item2 = [CCMenuItemImage itemWithNormalImage:@"NormalButtonImage.png" selectedImage:@"SelectedButtonImage.png" disabledImage:@"DisabledButtonImage.png" block:^(id sender) {
			CCLOG(@"CCMenuItemImage selected.");
		}];
		
		// トグルメニューを作ります
		NSArray* toggleMenuItems = [NSArray arrayWithObjects:
									[CCMenuItemFont itemWithString:@"ON"]
									,[CCMenuItemFont itemWithString:@"OFF"]
									, nil];
		CCMenuItemToggle *item3 = [CCMenuItemToggle itemWithItems:toggleMenuItems block:^(id sender){
			CCLOG(@"CCMenuItemToggle selected.");
		}];
		
		CCMenu* menu = [CCMenu menuWithItems:item, item2, item3, nil];
		
		// メニューが重なって表示されないように調整します
		[menu alignItemsVerticallyWithPadding:10.0];
		
		// メニューをレイヤーBに追加します
		[layerB addChild:menu];
	}
	
	return  self;
}

@end
