//
//  HelloWorldLayer.m
//  test
//
//  Created by 久保島 祐磨 on 12/07/13.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"
#import "NewScene.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		// 画面サイズを取得します
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// sample.pngを表示します
		CCSprite* sampleSprite = [CCSprite spriteWithFile:@"sample.png"];
		[self addChild:sampleSprite];
		
		// 画面サイズを表示する為のラベルを生成します
		//CCLabelTTF* label = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"W:%.2f, H:%.2f", winSize.width, winSize.height] fontName:@"Marker Felt" fontSize:40];
		
		// ビットマップフォントのHello Worldを生成します
		CCLabelBMFont *label = [CCLabelBMFont labelWithString:@"Hello World" fntFile:@"HelloWorld.fnt"];
		
		// ラベルの座標を画面中央に設定します
		label.position = CGPointMake(winSize.width / 2, winSize.height / 2);
		
		// ラベルをレイヤーに追加します
		[self addChild: label];
		
		// NewSceneに遷移する為のメニューを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:40];
		CCMenuItemFont* item = [CCMenuItemFont itemWithString:@"NewSceneへ" block:^(id sender) {
			[[CCDirector sharedDirector] replaceScene:[NewScene scene]];
		}];
		CCMenu* menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(winSize.width / 2, winSize.height / 2 - 60);
		// メニューをselfレイヤーに追加します
		[self addChild:menu];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
