//
//  TouchSprite.m
//  SpriteTouch
//
//  Created by 久保島 祐磨 on 12/07/16.
//  Copyright 2012年 株式会社 ICT Fractal. All rights reserved.
//

#import "TouchSprite.h"


@implementation TouchSprite

-(void) onEnter
{
	// CCTouchDispatcherに登録します（initメソッド内でコールしても機能しません。）
	[[[CCDirector sharedDirector] touchDispatcher] addTargetedDelegate:self priority:0 swallowsTouches:YES];
	
	// 忘れずにスーパークラスのonEnterをコールします
	[super onEnter];
}

-(void) onExit
{
	// CCTouchDispatcherから登録を削除します
	[[[CCDirector sharedDirector] touchDispatcher] removeDelegate:self];
	
	// 忘れずにスーパークラスのonExitをコールします
	[super onExit];
}

// タッチ開始
-(BOOL) ccTouchBegan:(UITouch *)touch withEvent:(UIEvent *)event
{
	BOOL isBlock = NO;
	
	// タッチ座標を、cocos2d座標に変換します
	CGPoint touchLocation = [touch locationInView:touch.view];
	CGPoint location = [[CCDirector sharedDirector] convertToGL:touchLocation];
	
	if (CGRectContainsPoint(self.boundingBox, location)) {
		// TouchSpriteの描画領域内でタッチされている場合、ログを表示します
		CCLOG(@"touch");
		
		// タッチイベントをブロックします
		isBlock = YES;
	}
	
	// このクラスでタッチイベントに対するアクションを行なわない場合、タッチイベントはブロックしません
	return isBlock;
}

// タッチ中移動
-(void) ccTouchMoved:(UITouch *)touch withEvent:(UIEvent *)event
{
	CCLOG(@"move");
}

// タッチ終了
-(void) ccTouchEnded:(UITouch *)touch withEvent:(UIEvent *)event
{
	CCLOG(@"end");
}

@end
