//
//  HelloWorldLayer.m
//  Sound
//
//  Created by 久保島 祐磨 on 12/07/15.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"
#import "SimpleAudioEngine.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
-(id) init
{
	if( (self=[super init]) ) {
		// BGMを先行読み込みします
		[[SimpleAudioEngine sharedEngine] preloadBackgroundMusic:@"bgm.mp3"];
		
		static BOOL isBgmStart = NO;
		
		// アクションを開始する為のメニューボタンを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:30];
		CCMenuItemFont* item = [CCMenuItemFont itemWithString:@"BGM" block:^(id sender) {
			if ([SimpleAudioEngine sharedEngine].isBackgroundMusicPlaying) {
				// BGM再生中の場合、停止します
				[[SimpleAudioEngine sharedEngine] pauseBackgroundMusic];
			}
			else {
				// BGM停止中の場合、再生します
				if (isBgmStart) {
					[[SimpleAudioEngine sharedEngine] resumeBackgroundMusic];
				}
				else {
					[[SimpleAudioEngine sharedEngine] playBackgroundMusic:@"bgm.mp3" loop:YES];
					isBgmStart = YES;
				}
			}
		}];
		CCMenuItemFont* item2 = [CCMenuItemFont itemWithString:@"Effect" block:^(id sender) {
			// 効果音を再生します
			[[SimpleAudioEngine sharedEngine] playEffect:@"effect.caf"];
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, item2, nil];
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		[menu alignItemsHorizontallyWithPadding:40];
		menu.position = CGPointMake(winSize.width / 2, winSize.height / 2);
		[self addChild:menu];
	}
	return self;
	[SimpleAudioEngine sharedEngine].effectsVolume = 1.0;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
