//
//  HelloWorldLayer.m
//  Schedule
//
//  Created by 久保島 祐磨 on 12/07/15.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

@interface HelloWorldLayer ()

// スケジュールメソッド
-(void) onScheduleEvent:(ccTime)delta;

@end

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// ラベルを作ります
		_label = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%d", _count] fontName:@"Marker Felt" fontSize:60];
		_label.position = CGPointMake(winSize.width / 2, winSize.height / 2);
		[self addChild:_label];
		
		// スケジュールをたてます
		[self schedule:@selector(onScheduleEvent:) interval:1];
		
		[self unscheduleUpdate];
	}
	return self;
}

// スケジュールメソッド
-(void) onScheduleEvent:(ccTime)delta
{
	// カウンタを+1します
	_label.string = [NSString stringWithFormat:@"%d", ++_count];
	
	// カウンタの値が10になった場合、スケジュールを停止する
	if (_count == 10) {
		[self unscheduleAllSelectors];
	}
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
