//
//  HelloWorldLayer.m
//  Reverse
//
//  Created by 久保島 祐磨 on 12/07/14.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// reverseを適用するラベルを作ります
		CCLabelTTF*	label1 = [CCLabelTTF labelWithString:@"Reverse" fontName:@"Marker Felt" fontSize:30];
		label1.position = CGPointMake(50, winSize.height - winSize.height / 2);
		[self addChild:label1];
		
		// アクションを開始する為のメニューボタンを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:30];
		CCMenuItemFont *item = [CCMenuItemFont itemWithString:@"Action" block:^(id sender) {
			// CCMoveByを作ります
			CCMoveBy* move = [CCMoveBy actionWithDuration:5 position:CGPointMake(winSize.width - 100, 0)];
			
			// moveオブジェクトのreverseオブジェクトを取得します
			id reverse = [move reverse];
			
			// （追加）CCDelayTimeオブジェクトを作ります
			CCDelayTime* delay = [CCDelayTime actionWithDuration:1];
			
			// （修正）CCSequenceを作ります
			CCSequence* seq = [CCSequence actions:move, delay, reverse, nil];
			
			// ラベルにCCSequenceを適用します
			[label1 runAction:seq];
			
			
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(winSize.width / 2, 60);
		[self addChild:menu];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
