//
//  HelloWorldLayer.m
//  Particle
//
//  Created by 久保島 祐磨 on 12/07/15.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"
#import "SimpleAudioEngine.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
-(id) init
{
	if( (self=[super init]) ) {
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// パーティクルシステムを生成します。
		CCParticleSystemQuad* particle = [[[CCParticleSystemQuad alloc] initWithTotalParticles:1000] autorelease];
		
		// 各プロパティを設定します
		particle.emitterMode = kCCParticleModeGravity;
		particle.blendFunc = (ccBlendFunc){GL_SRC_ALPHA, GL_ONE};
		particle.duration = -1;
		particle.sourcePosition = CGPointMake(winSize.width / 2, -20);
		particle.posVar = CGPointMake(winSize.width / 2, 0);
		particle.life = 0.5;
		particle.lifeVar = 4.5;
		particle.angle = 0;
		particle.angleVar = 0;
		particle.gravity = CGPointMake(0, 90);
		particle.speed = 0;
		particle.speedVar = 0;
		particle.radialAccel = 0;
		particle.radialAccelVar = 0;
		particle.tangentialAccel = 0;
		particle.tangentialAccelVar = 0;
		particle.startSpin = 0;
		particle.startSpinVar = 0;
		particle.startSize = 2;
		particle.startSizeVar = 16;
		particle.endSize = 40;
		particle.endSizeVar = 0;
		particle.startColor = ccc4f(0.62, 1, 0, 1);
		particle.startColorVar = ccc4f(1, 1, 1, 0);
		particle.endColor = ccc4f(0.9, 1, 0.9, 0);
		particle.endColorVar = ccc4f(0.8, 0.9, 0.95, 0);
		particle.emissionRate = 100;
		particle.texture = [[CCTextureCache sharedTextureCache] addImage:@"particle.png"];
		
		// パーティクルをレイヤーに追加します
		[self addChild:particle];
		
		[CCParticleSystemQuad particleWithFile:@""];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
