//
//  HelloWorldLayer.m
//  Call
//
//  Created by 久保島 祐磨 on 12/07/15.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		static NSInteger count = 0;
		
		// CCCallBlockを適用するラベルを作ります
		CCLabelTTF*	label = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%d", count] fontName:@"Marker Felt" fontSize:60];
		label.position = CGPointMake(winSize.width / 2, winSize.height / 2);
		[self addChild:label];
		
		// アクションを開始する為のメニューボタンを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:30];
		CCMenuItemFont *item = [CCMenuItemFont itemWithString:@"Action" block:^(id sender) {
			// １秒置きにカウントを増やすシーケンスを作ります
			CCDelayTime* delay = [CCDelayTime actionWithDuration:1];
			CCCallBlock* func = [CCCallBlock actionWithBlock:^(void){
				label.string = [NSString stringWithFormat:@"%d", count++];
			}];
			CCSequence* seq = [CCSequence actions:delay, func, nil];
			CCRepeatForever* rep = [CCRepeatForever actionWithAction:seq];
			
			// labelにアクションを適用します
			[label runAction:rep];
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(winSize.width / 2, 60);
		[self addChild:menu];
	}
	return self;
	
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
