//
//  HelloWorldLayer.m
//  Bezier
//
//  Created by 久保島 祐磨 on 12/07/14.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// CCBezierToを適用するラベルを作ります
		CCLabelTTF*	label1 = [CCLabelTTF labelWithString:@"A" fontName:@"Marker Felt" fontSize:30];
		label1.position = CGPointMake(50, winSize.height / 2);
		[self addChild:label1];
		
		// アクションを開始する為のメニューボタンを作ります
		[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
		[CCMenuItemFont setFontSize:30];
		CCMenuItemFont *item = [CCMenuItemFont itemWithString:@"Action" block:^(id sender) {
			// 座標をccBezierConfigに設定します
			ccBezierConfig bezier;
			bezier.controlPoint_1 = CGPointMake(winSize.width / 4, winSize.height);
			bezier.controlPoint_2 = CGPointMake(winSize.width / 2, 0);
			bezier.endPosition = CGPointMake(winSize.width - 50, winSize.height / 2);
			
			// CCBezierToを適用します
			CCBezierTo* bezierTo = [CCBezierTo actionWithDuration:5 bezier:bezier];
			[label1 runAction:bezierTo];
		}];
		CCMenu *menu = [CCMenu menuWithItems:item, nil];
		menu.position = CGPointMake(winSize.width / 2, 60);
		[self addChild:menu];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
