//
//  HelloWorldLayer.m
//  Animation
//
//  Created by 久保島 祐磨 on 12/07/14.
//  Copyright 株式会社 ICT Fractal 2012年. All rights reserved.
//


// Import the interfaces
#import "HelloWorldLayer.h"

// Needed to obtain the Navigation Controller
#import "AppDelegate.h"

#pragma mark - HelloWorldLayer

// HelloWorldLayer implementation
@implementation HelloWorldLayer

// Helper class method that creates a Scene with the HelloWorldLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	HelloWorldLayer *layer = [HelloWorldLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

-(id) init
{
	if( (self=[super init])) {
		
		CGSize winSize = [[CCDirector sharedDirector] winSize];
		
		// 背景として白いレイヤーを貼付けます
		CCLayerColor* backGround = [CCLayerColor layerWithColor:ccc4(255, 255, 255, 255)];
		[self addChild:backGround];
		
		// １．アニメーションさせるスプライトを作ります
		CCSprite* image = [CCSprite spriteWithFile:@"robo1.png"];
		[self addChild:image];
		
		// ２．CCAnimationオブジェクトを生成します
		CCAnimation* animation = [CCAnimation animation];
		
		// ３．CCAnimationオブジェクトに２枚の画像を登録します
		[animation addSpriteFrameWithFilename:@"robo1.png"];
		[animation addSpriteFrameWithFilename:@"robo2.png"];
		
		// ４．CCAnimationオブジェクトに1フレーム当たりの秒数を設定します
		animation.delayPerUnit = 0.5;
		
		// ５．アニメーションに無限ループを設定します
		animation.loops = -1;
		
		// ６．CCAnimateオブジェクトを生成します
		CCAnimate* animate = [CCAnimate actionWithAnimation:animation];
		
		// CCMoveToオブジェクトを作ります
		CCMoveTo* move = [CCMoveTo actionWithDuration:5 position:CGPointMake(winSize.width / 2, winSize.height / 2)];
		
		// CCSequenceオブジェクトを作ります
		//CCSequence* seq = [CCSequence actions:move, animate, nil];
		
		// （追加）CCSpawnオブジェクトを作ります
		CCSpawn* spawn = [CCSpawn actions:move, animate, nil];
		
		// （追加）スプライトにSpawnを適用します
		[image runAction:spawn];
		
		// スプライトにシーケンスを適用します
		//[image runAction:seq];
		
		// ７．スプライトにCCAnimateオブジェクトを適用します
		//[image runAction:animate];
	}
	return self;
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
	[super dealloc];
}

#pragma mark GameKit delegate

-(void) achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}

-(void) leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
	AppController *app = (AppController*) [[UIApplication sharedApplication] delegate];
	[[app navController] dismissModalViewControllerAnimated:YES];
}
@end
