//
//  TitleLayer.m
//  15Puzzle
//
//  Created by 久保島 祐磨 on 12/07/19.
//  Copyright 2012年 株式会社 ICT Fractal. All rights reserved.
//

#import "TitleLayer.h"
#import "GameLayer.h"


@implementation TitleLayer

+(CCScene *) scene
{
	CCScene *scene = [CCScene node];
	TitleLayer *layer = [TitleLayer node];
	[scene addChild: layer];
	
	return scene;
}

-(void) onEnter
{
	// スーパークラスのonEnterをコールします
	[super onEnter];
	
	CGSize winSize = [[CCDirector sharedDirector] winSize];
	
	// 背景絵を表示します
	CCSprite* backImage = [CCSprite spriteWithFile:@"image.png"];
	backImage.position = CGPointMake(winSize.width / 2, winSize.height / 2);
	backImage.color = ccc3(100, 100, 100);
	[self addChild:backImage z:0];
	
	// ゲームスタートメニューを表示します
	[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
	[CCMenuItemFont setFontSize:60];
	CCMenuItemFont *item = [CCMenuItemFont itemWithString:@"ゲームスタート" block:^(id sender) {
		// GameLayerを表示します
		[[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[GameLayer scene] withColor:ccWHITE]];
	}];
	CCMenu *menu = [CCMenu menuWithItems:item, nil];
	menu.position = CGPointMake(winSize.width / 2, 60);
	[self addChild:menu];
}

@end
