//
//  ClearLayer.m
//  15Puzzle
//
//  Created by 久保島 祐磨 on 12/07/19.
//  Copyright 2012年 株式会社 ICT Fractal. All rights reserved.
//

#import "ClearLayer.h"
#import "TitleLayer.h"


@implementation ClearLayer

-(void) onEnter
{
	// スーパークラスのonEnterをコールします
	[super onEnter];
	
	CGSize winSize = [[CCDirector sharedDirector] winSize];
	
	// 半透明のカラーレイヤーを被せ、メッセージやメニューを見えやすくします
	CCLayerColor* layer = [CCLayerColor layerWithColor:ccc4(100, 100, 100, 100)];
	[self addChild:layer];
	
	// ゲームクリア表示のラベルを生成します
	CCLabelTTF* label = [CCLabelTTF labelWithString:@"Congratulations!!" fontName:@"Chalkduster" fontSize:40];
	label.color = ccc3(30, 30, 255);
	label.scaleY = 1.5;
	label.position = CGPointMake(winSize.width / 2, winSize.height - winSize.height / 4);
	[self addChild:label];
	
	// タイトルに戻るメニューを生成します
	[CCMenuItemFont setFontName:@"Helvetica-BoldOblique"];
	[CCMenuItemFont setFontSize:30];
	CCMenuItemFont *item = [CCMenuItemFont itemWithString:@"タイトルに戻る" block:^(id sender) {
		// TitleLayerを表示します
		[[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[TitleLayer scene] withColor:ccWHITE]];
	}];
	CCMenu *menu = [CCMenu menuWithItems:item, nil];
	menu.position = CGPointMake(winSize.width / 2, 60);
	[self addChild:menu];
}

@end
